% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriche}
\alias{deriche}
\title{Apply recursive Deriche filter.}
\usage{
deriche(im, sigma, order = 0L, axis = "x", boundary_conditions = 0L)
}
\arguments{
\item{im}{an image}

\item{sigma}{Standard deviation of the filter.}

\item{order}{Order of the filter. Can be <tt>{ 0=smooth-filter | 1=1st-derivative | 2=2nd-derivative }</tt>.}

\item{axis}{Axis along which the filter is computed. Can be <tt>{ 'x' | 'y' | 'z' | 'c' }</tt>.}

\item{boundary_conditions}{Boundary conditions. Can be <tt>{ 0=dirichlet | 1=neumann }</tt>.}
}
\description{
Apply recursive Deriche filter.
}
\examples{
deriche(boats,sigma=2,order=0) \%>\% plot("Zeroth-order Deriche along x")
deriche(boats,sigma=2,order=1) \%>\% plot("First-order Deriche along x")
deriche(boats,sigma=2,order=1) \%>\% plot("Second-order Deriche along x")
deriche(boats,sigma=2,order=1,axis="y") \%>\% plot("Second-order Deriche along y")
}

