% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{imager.replace}
\alias{imager.replace}
\alias{channel<-}
\alias{R<-}
\alias{G<-}
\alias{B<-}
\alias{frame<-}
\title{Replace part of an image with another}
\usage{
channel(x, ind) <- value

R(x) <- value

G(x) <- value

B(x) <- value

frame(x, ind) <- value
}
\arguments{
\item{x}{an image to be modified}

\item{ind}{an index}

\item{value}{the image to insert}
}
\description{
These replacement functions let you modify part of an image (for example, only the red channel).
Note that cimg objects can also be treated as regular arrays and modified using the usual [] operator.
}
\section{Functions}{
\itemize{
\item \code{channel<-}: Replace image channel

\item \code{R<-}: Replace red channel

\item \code{G<-}: Replace green channel

\item \code{B<-}: Replace blue channel

\item \code{frame<-}: Replace image frame
}}

\examples{
boats.cp <- boats
#Set the green channel in the boats image to 0
G(boats.cp) <- 0
#Same thing, more verbose
channel(boats.cp,2) <- 0
#Replace the red channel with noise
R(boats.cp) <- imnoise(width(boats),height(boats))
#A new image with 5 frames
tmp <- imfill(10,10,5)
#Fill the third frame with noise
frame(tmp,3) <- imnoise(10,10)
}
\seealso{
imdraw
}
