% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{imager.subset}
\alias{imager.subset}
\title{Array subset operator for cimg objects}
\arguments{
\item{x}{an image (cimg object)}

\item{drop}{if true return an array, otherwise return an image object (default FALSE)}

\item{...}{subsetting arguments}
}
\description{
Internally cimg objects are 4D arrays (stored in x,y,z,c mode) but often one doesn't need all dimensions. This is the case for instance when working on grayscale images, which use only two. The array subset operator works like the regular array [] operator, but it won't force you to use all dimensions.
There are easier ways of accessing image data, for example imsub, channels, R, G, B, and the like.
}
\examples{
im <- imfill(4,4)
dim(im) #4 dimensional, but the last two ones are singletons
im[,1,,] <- 1:4 #Assignment the standard way
im[,1] <- 1:4 #Shortcut
as.matrix(im)
im[1:2,]
dim(boats)
#Arguments will be recycled, as in normal array operations
boats[1:2,1:3,] <- imnoise(2,3) #The same noise array is replicated over the three channels
}
\seealso{
imsub, which provides a more convenient interface, autocrop, imdraw
}
