## Changes in Version 2.7

  * Updated Description: Orcid Id added, packages required for unit test add as "Suggested"

  * Small correction in README.md, small update to citation file
  
  * Replaced NEWS with NEWS.md for better formatting
  

## Changes in Version 2.6

  * Updated citation file
  
  * Minor changes to vignette


## Changes in Version 2.5

  * Adjusted unit test to a update of forecast package
  


## Changes in Version 2.4

  * Small speed improvments for na.kalman
  
  * Improved input check for all functions

  * Bugfix for unit tests 

  * Changes to unit test (because of zoo update)
  

## Changes in Version 2.3

  * Bugfix for na.kalman with integer input
  
  * Readme Update

  * Improved error messages for na.seasplit and na.seadec

  * Minor vignette changes


## Changes in Version 2.2

  * Bugfix for na.locf (also concerned na.kalman) 
  

## Changes in Version 2.1

  * Fixed for problems with Solaris/Sparc
  
  * Fixes for problems with vignette on osx


## Changes in Version 2.0

  * Bugfix for plots without missing data
  
  * Increased performance for na.locf
  
  * Minor bugfixes for specific data.frame inputs
  
  * Minor bugfixes for specific xts object inputs

  * Improved Code Documentation
  
  * Added new software tests


## Changes in Version 1.9

  * Added Vignette


## Changes in Version 1.8

  * Computation time improvments for na.locf (up to 10000 times faster)
  
  * Computation time improvments for na.interpolation (up to 10000 times faster)
  
  * Computation time improvments for na.kalman (only slightly faster, under 10%)
  
  * Fixed unnecessary warning message with some na.kalman options
  
  * Adjusted default parameters for plotNA.distributionBar (using nclass.Sturges for breaks parameter)
  
  * Fixed issue with too sensitive input checking
  

## Changes in Version 1.7
  
  * Enabled usage of multivariate input (data.frame, mts, matrix,...) for all imputation 
    functions except na.remove. This means users do not have to loop through all columns 
    by themselfes anymore if they want to use the package with multivariate data. The
    imputation itself is still performend in univariate manner (column after column). 
  
  * Improved compatibility with different advanced time series objects like zoo and xts.
    Using the imputation functions with these time series objects should be possible now. 
    These series will not be explicitly named as possible input in the user documentation.
    Absence of errors can not be guaranteed. However, there are no known issues yet.
  
  * Added several things for unit tests with pkg 'testthat'
  
  * Added unit tests for every function
  
  * Adjusted error messages
  
  * Internal Coding style improvement: replaced all T with TRUE and all F with FALSE
  
  * Adjustment tsHeating / tsHeatingComplete datasets (set 1440 as frequency parameter)
  
  * Adjustment tsNH4 / tsNH4Complete datasets (set 144 as frequency parameter)
  
  * Fixes for grammar, spelling and citations in the whole documentation
  
  * Revised examples in the documentation for all functions
 
  * Restricted output of na.remove to vector only (issue with incorrect time information otherwise)
  
  * Added better x-axes labels for plotNA.distribution
  

## Changes in Version 1.6
  
  * Added github links to description file
  
  * Added citation file
  
  * Updated Readme (badges for travis ci and cran status)
  
  * Fix in documentation for na.interpolation 
   (due to outdated descriptions)
   
  * Fix in documentation plotNA.distribution / plotNA.distributionBar
    (due to interchanged descriptions)
    
  * Added references to used packages in na.kalman and na.interpolation documentation


## Changes in Version 1.5

  * Allows now also numeric vectors as input

  * Removed na.identifier parameter for all functions (too error prone, better handled 
    individually by the user)

  * Minor changes in na.interpolation with option = "stine"
  
  * Added na.ma imputation function

  * Replaced "data" in all function parameters with the more common "x"

  * Improvement of all code examples

  * Renamed heating/heatingComplete dataset to tsHeating/tsHeatingComplete

  * Renamed nh4/nh4Complete dataset to tsNH4/tsNH4Complete

  * Added tsAirgap / tsAirgapComplete datasets

  * Improved imputeTS-package documentation

  * Added na.kalman imputation function

  * Added README.md function

  * Added statsNA function

  * Added plotNA.gapsize function
  
  * Renamed vis.imputations to plotNA.imputations

  * Renamed vis.barMissing to plotNA.distributionBar

  * Renamed vis.missing to plotNA.distribution
  
  * Fixed issues with parameter pass through and legend for
    all plotting functions
    
  * Improved dataset documentation 


## Changes in Version 0.4

  * Update of vis.differences (better looking plot now)
  
  * Added vis.missing to visualize the distribution of missing data in a time series
  
  * Added vis.barMissing, which is especially suited to visualize missing data in very huge time series
  
  * Update na.interpolate (added Stineman interpolation and enabled ... parameter 
    for all interpolation algorithms to pass through parameters to the underlying functions)


## Changes in Version 0.3

  * Added two datasets of sensor data
  
  * vis.differences for plotting differences between real and imputed values
  

## Changes in Version 0.2

  * Removed internal functions from visible package documentation

  * Added additional algorithms: na.seasplit and na.seadec
  
  * internal function for algorithm selection
  

## Changes in Version 0.1

  * Created initial version of imputeTS package for univariate time series imputation

  * added the simple imputation functions: na.locf, na.mean, na.random, na.interpolation, 
    na.replace

  * added na.remove function for removing all NAs from a time series
