% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSummaryStatistics.R
\name{computeSummaryStatistics}
\alias{computeSummaryStatistics}
\title{Compute summary statistics of interest of an unique variable of interest.}
\usage{
computeSummaryStatistics(
  data,
  var = NULL,
  varTotalInclude = FALSE,
  statsExtra = NULL,
  subjectVar = "USUBJID",
  filterEmptyVar = TRUE,
  type = "auto",
  checkVarDiffBySubj = c("error", "warning", "none"),
  msgLabel = NULL,
  msgVars = NULL
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{varTotalInclude}{Logical (FALSE by default)
Should the total across all categories of \code{var} 
be included for the count table?
Only used if \code{var} is a categorical variable.}

\item{statsExtra}{(optional) Named list with functions for additional custom
statistics to be computed.\cr
Each function:
\itemize{
\item{has as parameter, either: }{'x': the variable (\code{var}) to compute
the summary statistic on or 'data': the entire dataset}
\item{returns the corresponding summary statistic as a numeric vector}
}
For example, to additionally compute the coefficient of variation, this can be set to:
\code{list(statCVPerc = function(x) sd(x)/mean(x)*100)} (or \code{\link{cv}}).}

\item{subjectVar}{String, variable of \code{data} with subject ID,
'USUBJID' by default.}

\item{filterEmptyVar}{Logical, if TRUE doesn't return any results
if the variable is empty, otherwise return 0 for the counts and NA for summary 
statistics.
Criterias to consider a variable empty are:
\itemize{
\item{for a continuous variable: }{all missing (NA)}
\item{for a categorical variable: }{all missing or **category is included in the 
factor levels but not available in \code{data}**}
}
By default, an empty variable are filtered.}

\item{type}{String with type of table: 
\itemize{
\item{'summaryTable': }{summary table with statistics for numeric variable}
\item{'countTable': }{count table}
\item{'auto' (by default): }{'summaryTable' if the variable is numeric,
'countTable' otherwise}
}}

\item{checkVarDiffBySubj}{String, 'error' (default), 'warning',
or 'none'.  
Should an error, a warning, or nothing be produced
if a continuous variable (\code{var}) contains
different values for the same subject?}

\item{msgLabel}{(optional) String with label for the data (NULL by default), 
included in the message/warning for checks.}

\item{msgVars}{(optional) Character vector with columns of \code{data}
containing extra variables (besides \code{var} and \code{subjectVar})
that should be included in the message/warning for checks.}
}
\value{
Data.frame with summary statistics in columns,
depending if \code{type} is:
\itemize{
\item{'summary': }{
\itemize{
\item{'statN': }{number of subjects}
\item{'statm': }{number of records}
\item{'statMean': }{mean of \code{var}}
\item{'statSD': }{standard deviation of \code{var}}
\item{'statSE': }{standard error the mean of \code{var}}
\item{'statMedian': }{median of \code{var}}
\item{'statMin': }{minimum of \code{var}}
\item{'statMax': }{maximum of \code{var}}
}
}
\item{'count': }{
\itemize{
\item{'variableGroup': }{factor with groups of \code{var} for which counts are reported}
\item{'statN': }{number of subjects}
\item{'statm': }{number of records}
}
}
}
}
\description{
Additionally, this function run extra checks on the data:
\itemize{
\item{an error message is triggered if any subject (identified by \code{subjectVar}) 
have different values in a continuous \code{var}
}
\item{an indicative message is triggered if multiple but identical records are available
for \code{subjectVar} and a continuous \code{var}}
}
}
\author{
Laure Cougnaud
}
