% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_incidence.R
\name{build_incidence}
\alias{build_incidence}
\title{Coerce to incidence}
\usage{
build_incidence(
  x,
  date_index,
  groups = NULL,
  counts = NULL,
  na_as_group = TRUE,
  FUN = identity,
  args = list()
)
}
\arguments{
\item{x}{A data frame representing a linelist (or potentially a
pre-aggregated dataset).}

\item{date_index}{The time index(es) of the given data. Multiple inputs only
make sense when x is a linelist, and in this situation, to avoid ambiguity,
the vector must be named.  These names will be used for the resultant count
columns.}

\item{groups}{An optional vector giving the names of the groups of
observations for which incidence should be grouped.}

\item{counts}{The count variables of the given data.  If NULL (default) the
data is taken to be a linelist of individual observations.}

\item{na_as_group}{A logical value indicating if missing group values (NA)
should treated as a separate category (\code{TRUE}) or removed from
consideration (\code{FALSE}). Defaults to \code{TRUE}.}

\item{FUN}{Function applied to the \code{dates_index} vectors before grouping. The
first argument of \code{FUN} must work with a \code{dates_index} vector. Defaults to
the identity function.}

\item{args}{List of additional arguments passed to FUN.}
}
\value{
An \verb{incidence_df`` object.  This is a subclass of [}tibble\verb{][}tibble::tbl-df`] represents an aggregated count of
observations. It will contain the following columns:

\strong{date_index}:  If the default interval of 1 day is used then
this will be the dates of the given observations and given the name
"date", otherwise, this will be values obtained from the specified date
grouping with column name "date_index" (See Interval specification below).
\itemize{
\item \strong{count} (or name of count variables): The aggregated observation counts.
\item \strong{groups} (if specified): column(s) containing the categories of the
given groups.
}
}
\description{
\code{build_incidence()} coerces an object to an incidence of events.
}
