% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.table.R
\name{as.data.table.incidence2}
\alias{as.data.table.incidence2}
\title{Coerce to a data.table}
\usage{
\method{as.data.table}{incidence2}(x, keep.rownames, ...)
}
\arguments{
\item{x}{An \link[=incidence]{incidence2} object.}

\item{keep.rownames}{Not used.}

\item{...}{Passed to other methods.}
}
\value{
A \link[data.table:data.table]{data.table} of the original input but with no
additional attributes.
}
\description{
Coerce to a data.table
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    x <- incidence(dat, "date_of_onset")
    as.data.table(x)
}
\dontshow{data.table::setDTthreads(.old)}

}
\seealso{
\link[data.table:as.data.table]{data.table::as.data.table} for the underlying generic.
}
