% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{bsDataStep}
\alias{bsDataStep}
\title{Generate bootstrap distribution of fitted coefficients}
\usage{
bsDataStep(
  object,
  bs_data = c("parametric", "ordinary"),
  R,
  useBoot = FALSE,
  smd_factor = 0
)
}
\arguments{
\item{object}{an \code{incubate_fit}-object}

\item{bs_data}{character. Which type of bootstrap method to generate data?}

\item{R}{integer. Number of bootstrapped model coefficient estimates}

\item{useBoot}{flag. Do you want to use the boot-package? Default value is \code{FALSE}.}

\item{smd_factor}{numeric. smooth-delay factor: influence the amount of smoothing. Default is 0.025}
}
\value{
bootstrap data, either as matrix or of class \code{boot} (depending on the \code{useBoot}-flag)
}
\description{
Bootstrap data are here estimated coefficients from models fitted to bootstrap samples.
These bootstrap data are used to make bootstrap inference in the second step.
It is an internal function, the main entry point is \code{\link[=confint.incubate_fit]{confint.incubate_fit()}}.
}
