% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{mV}
\alias{mV}
\title{Helper function that translates elicited quantiles of target into independent
conditional means normal prior for a defined inverse link function.}
\usage{
mV(Z, fit.method = "KL")
}
\arguments{
\item{Z}{list object that contains matrix \code{theta} of elicitations and
character \code{link}, see \code{plotDesignPoint()}}

\item{fit.method}{character, \code{moment}, \code{KL}, \code{SS}. Default is
\code{KL}.}
}
\value{
A list with vector of means \code{m} and diagonal covariance matrix 
  \code{V}.
}
\description{
The default for \code{fit.method} is option \code{KL}. This option uses an 
objective function that minimises a discretised directed divergence from a 
cumulative distribution implied by raw elicited fractiles to a normal 
conditional mean prior for the linear predictor. An alterative method 
\code{moment} assigns the location parameter of the normal conditional mean 
prior to the elicited median on the linear predictor scale. The variance 
parameter is estimated as \eqn{V = ((g(f_u) - g(f_l)/(qnorm(u) -
qnorm(l)))^2}, where \eqn{l} is the probability associated with the fractile
\eqn{f_l} that defines the lower bound for the central credible interval and 
\eqn{u} is the probability associated with the fractile \eqn{f_u} that
defines the upper bound for the central credible interval. This is also used
to initialise the optimisation for the \code{KL} method. Another optimsation 
method that minimises the sum of squares is also available as method 
\code{SS}. See the vignette for more details on the choice of objective 
function for \code{KL} and \code{SS}.
}
