% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_denue.R
\name{denue}
\alias{denue}
\alias{inegi_denue}
\alias{denue_inegi}
\title{Returns DENUE businesses}
\usage{
inegi_denue(latitud, longitud, token, metros = 250, keyword = "todos")

denue_inegi(latitud, longitud, token, metros = 250, keyword = "todos")
}
\arguments{
\item{latitud}{Character vector with latitud (in decimals)}

\item{longitud}{Character vector with longitud (in decimals)}

\item{token}{API token supplied by INEGI}

\item{metros}{Meters to search in a circle from coordinates. Defaults to 250}

\item{keyword}{Keyword to search in business description (in spanish). Defaults to all (todos).}
}
\value{
Data.frame
}
\description{
Returns data.frame with businesses registered in DENUE in the vicinity of supplied coordinates.
}
\examples{
# All businesses in a 1 km radius from the Macroplaza in Monterrey, Mex.
\dontrun{
token<-"webservice_token"
latitud<-"25.669194"
longitud<-"-100.30990"
# in english
businesses <- inegi_denue(latitud, longitud, token, metros = 1000)
# in spanish (legacy)
negocios <- denue_inegi(latitut, longitud, token, metros = 100)
}

}
\author{
Eduardo Flores
}
