% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_series_es.R
\name{serie_inegi}
\alias{serie_inegi}
\alias{serie_inegi}
\alias{serie_inegi_json}
\title{Obtiene serie de tiempo de INEGI}
\usage{
serie_inegi(serie, token, metadata = FALSE, coercionar = TRUE)

serie_inegi_json(serie, token, metadata = FALSE, coercionar = TRUE)
}
\arguments{
\item{serie}{Vector en caracter de url de dirección. Este es un metódo directo (se requiere de URL en formato XML, con token)}

\item{token}{token personal emitido por el INEGI para acceder al API.}

\item{metadata}{Default = FALSE, si TRUE, parsea una lista con metadatos de serie.}

\item{coercionar}{Por default (TRUE), los indicadores quincenales serán coercionados a mensuales. Aparecerán todas las observaciones pero en el mismo día del mes a pesar de estar en diferentes quincenas. Para usar días = FALSE.}
}
\value{
Dataframe o lista
}
\description{
Regresa data.frame con la serie de tiempo escogida, al buscar en el webservice del INEGI y parsear via XML y ZOO. 
Si parametro Metadata=TRUE, regresa lista con indicadores meta y datos.
Es una de las funciones primitivas del paquete.
}
\note{
La instancia "?callback?", requerida por la documentación del INEGI para series JSON no es necesaria.
}
\examples{
\dontrun{
#Serie de INPC General 
token<-"webservice_token"
url <- "http://www3.inegi.org.mx/sistemas/api/indicadores/v1//Indicador/216064/00000/es/false/xml/"
Serie <- serie_inegi(url, token)
}
}
\author{
Eduardo Flores
}
