% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossweight.R
\name{crossweight}
\alias{crossweight}
\title{Perform crossweighting}
\usage{
crossweight(
  weight_table,
  matrix,
  meta_data = NULL,
  lag = floor(ncol(matrix)/5),
  min = ceiling(ncol(matrix)/50),
  max = floor(ncol(matrix)/12),
  symmetric_filter = FALSE,
  filter_thresh = 0
)
}
\arguments{
\item{weight_table}{GRN dataframe, the result of running reconstructargetRN or reconstructargetRN_GENIE3}

\item{matrix}{genes-by-cells expression matrix}

\item{meta_data}{result of running findDynGenes}

\item{lag}{lag window on which to run cross-correlation. Cross-correlaiton computed from -lag to +lag.}

\item{min}{minimum of weighting window. Edges with offsets (or absolute offsets if symmetric_filter=TRUE) less than min will not be negatively weighted.}

\item{max}{maximum of weighting window. Edges with offsets (or absolute offsets if symmetric_filter=TRUE) greater than max will have weights set to 0.}

\item{symmetric_filter}{whether or not to employ a symmetric weight scheme. If true, absolute offset is used in place of offset.}

\item{filter_thresh}{after crossweighting, edges with weights less than filter_thresh will be set to 0.}
}
\value{
weight_table with offset and weighted_score added
}
\description{
Perform crossweighting
}
\examples{
\dontrun{
library(inferCSN)
data("example_matrix")
weight_table <- inferCSN(example_matrix, verbose = TRUE)
weight_table_new <- crossweight(
  weight_table,
  matrix = t(example_matrix)
)
p1 <- network.heatmap(weight_table)
p2 <- network.heatmap(weight_table_new[, 1:3])
p1 + p2
}
}
