% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/integrands.R
\name{logit_integrand}
\alias{logit_integrand}
\title{Default integrand for the group-level propensity score}
\usage{
logit_integrand(b, X, A, fixed.effects, random.effects = NULL, x = NULL,
  pos = NULL, allocation = NULL, randomization = 1,
  integrate.allocation = FALSE)
}
\arguments{
\item{b}{vector argument of values necessary for \code{\link{integrate}}.}

\item{X}{n by length(fixed.effects) matrix of covariates.}

\item{A}{vector of observed treatments (0,1)}

\item{fixed.effects}{vector of fixed effect parameters.}

\item{random.effects}{OPTIONAL vector of random effect parameters. If provided,
only the first element is used. If this element is <= 0, it is ignored.}

\item{x}{Used by \code{\link{grad}} for taking the derivative with respect an element of
params. Only used if \code{pos} is not NULL.}

\item{pos}{The position of theta for which to take the derivative. Defaults to NULL.}

\item{allocation}{The allocation strategy. Required if include.allocations == TRUE.
Defaults to NA.}

\item{randomization}{Randomization probability. Defaults to 1.}

\item{integrate.allocation}{Either TRUE for including allocation in the product or FALSE
does not include allocation.}
}
\value{
value of the integrand
}
\description{
Computes the following function:
\deqn{\prod_{j=1}^{n} (r h_{j}(b))^{A_j}  (1 - r h_{j}(b))^{1 - A_j}
f_b(b; \theta_b)}{ prod(r * plogis(X * fixef + b)^A *
(1 - r * plogis(X * fixef+ b))^(1 - A)) *
dnorm(sd = sqrt(ranef))}
where \eqn{r} is the randomization scheme. \eqn{X} is the covariate(s) vectors.
\eqn{fixef} is the vector of fixed effects. \eqn{b} is the random (group-level) effect.
\eqn{ranef} is the random effect variance.
}

