% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{degree}
\alias{degree}
\alias{DC}
\title{Degree of the vertices}
\usage{
degree(
  graph,
  v = V(graph),
  mode = c("all", "out", "in", "total"),
  loops = TRUE,
  normalized = FALSE
)
}
\arguments{
\item{graph}{The graph to analyze (an igraph graph).}

\item{v}{The ids of vertices of which the degree will be calculated.}

\item{mode}{Character string, “out” for out-degree, “in” for in-degree or “total” for the sum of the two.
For undirected graphs this argument is ignored. “all” is a synonym of “total”.}

\item{loops}{Logical; whether the loop edges are also counted.
If the graph has a weight edge attribute, then this is used by default. Weights are used to calculate weighted shortest paths, so they are interpreted as distances.}

\item{normalized}{Logical scalar, whether to normalize the degree.
If TRUE then the result is divided by n-1, where n is the number of vertices in the graph.}
}
\value{
A numeric vector of the same length as argument v.
}
\description{
This function and all of its descriptions have been obtained from the igraph package.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
My_graph_degree <- degree(My_graph, v = GraphVertices, normalized = FALSE)
}
}
\seealso{
\code{\link[influential]{ivi}},
\code{\link[influential]{cent_network.vis}},
and \code{\link[igraph]{degree}} for a complete description on this function

Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{clusterRank}()},
\code{\link{collective.influence}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()},
\code{\link{sirir}()}
}
\concept{centrality functions}
\keyword{degree_centrality}
