% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceteris_paribus.R
\name{ceteris_paribus}
\alias{ceteris_paribus}
\alias{ceteris_paribus.explainer}
\alias{ceteris_paribus.default}
\title{Ceteris Paribus Profiles aka Individual Variable Profiles}
\usage{
ceteris_paribus(x, ...)

\method{ceteris_paribus}{explainer}(
  x,
  new_observation,
  y = NULL,
  variables = NULL,
  variable_splits = NULL,
  grid_points = 101,
  ...
)

\method{ceteris_paribus}{default}(
  x,
  data,
  predict_function = predict,
  new_observation,
  y = NULL,
  variables = NULL,
  variable_splits = NULL,
  grid_points = 101,
  label = class(x)[1],
  ...
)
}
\arguments{
\item{x}{an explainer created with the \code{DALEX::explain()} function, or a model to be explained.}

\item{...}{other parameters}

\item{new_observation}{a new observation with columns that corresponds to variables used in the model}

\item{y}{true labels for \code{new_observation}. If specified then will be added to ceteris paribus plots.
NOTE: It is best when target variable is not present in the \code{new_observation}}

\item{variables}{names of variables for which profiles shall be calculated.
Will be passed to \code{\link{calculate_variable_split}}.
If NULL then all variables from the validation data will be used.}

\item{variable_splits}{named list of splits for variables, in most cases created with \code{\link{calculate_variable_split}}.
If NULL then it will be calculated based on validation data available in the \code{explainer}.}

\item{grid_points}{maximum number of points for profile calculations. Note that the finaln number of points may be lower than \code{grid_points}, eg. if there is not enough unique values for a given variable. Will be passed to \code{\link{calculate_variable_split}}.}

\item{data}{validation dataset. It will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{predict_function}{predict function. It will be extracted from \code{x} if it's an explainer}

\item{label}{name of the model. By default it's extracted from the \code{class} attribute of the model}
}
\value{
an object of the class \code{ceteris_paribus_explainer}.
}
\description{
This explainer works for individual observations.
For each observation it calculates Ceteris Paribus Profiles for selected variables.
Such profiles can be used to hypothesize about model results if selected variable is changed.
For this reason it is also called 'What-If Profiles'.
}
\details{
Find more details in \href{https://pbiecek.github.io/ema/ceterisParibus.html}{Ceteris Paribus Chapter}.
}
\examples{
library("DALEX")
# smaller data, quicker example
titanic_small <- select_sample(titanic_imputed, n = 500, seed = 1313)

# build a model
model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_small,
                         family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_small[,-8],
                               y = titanic_small[,8],
                               verbose = FALSE)

cp_rf <- ceteris_paribus(explain_titanic_glm, titanic_small[1,])
cp_rf

plot(cp_rf, variables = "age")

\donttest{
library("randomForest")
model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)


explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "Random Forest v7",
                              verbose = FALSE)

# select few passangers
selected_passangers <- select_sample(titanic_imputed, n = 20)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red")

}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
