% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla.R
\name{predict.inla}
\alias{predict.inla}
\title{Prediction from fitted inla model}
\usage{
\method{predict}{inla}(object, ...)
}
\arguments{
\item{object}{A \code{bru} object obtained by calling \link{bru} or \link{lgcp}.}

\item{...}{Arguments passed on to \link{predict.bru}.}
}
\value{
A \code{prediction} object.
}
\description{
Takes a fitted inla object produced by the function inla() and produces predictions given a 
new set of values for the model covariates or the original values used for the model fit. 
The predictions can be based on any R expression that is valid given these values/covariates 
and the posterior of the estimated effects.
}
\examples{
\donttest{
# Some features use the INLA package.
if (require("INLA", quietly = TRUE)) {

# Generate some data

input.df <- data.frame(x=cos(1:10))
input.df <- within(input.df, y <- 5 + 2*cos(1:10) + rnorm(10, mean=0, sd=0.1))

# Fit a Gaussian likelihood model

formula = y ~ x
fit <- inla(formula, "gaussian", data = input.df, control.compute=list(config = TRUE))

# Estimate posterior statistics of exp(x), where x is the fixed effect.

xpost = predict(fit, NULL, ~ exp(x))
xpost
plot(xpost)

}
}
}
\author{
Fabian E. Bachl <\email{bachlfab@gmail.com}>
}
