# inlmisc

[![Travis Build Status](https://travis-ci.org/USGS-R/inlmisc.svg?branch=master)](https://travis-ci.org/USGS-R/inlmisc)
[![Coverage Status](https://coveralls.io/repos/github/USGS-R/inlmisc/badge.svg?branch=master)](https://coveralls.io/github/USGS-R/inlmisc?branch=master)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/inlmisc)](https://CRAN.R-project.org/package=inlmisc)
[![](https://cranlogs.r-pkg.org/badges/inlmisc?color=brightgreen)](https://CRAN.R-project.org/package=inlmisc)
[![USGS Category](https://img.shields.io/badge/USGS-Support-yellow.svg)](https://owi.usgs.gov/R/packages.html#support)

## Overview

The [R](https://www.r-project.org/) package **inlmisc** is a collection of functions for creating high-level graphics,
performing raster-based analysis, processing [MODFLOW](https://www.usgs.gov/mission-areas/water-resources/science/modflow-and-related-programs "USGS's modular hydrologic model")-based models,
selecting subsets using a genetic algorithm, creating interactive web maps, accessing color palettes, etc.
Used to support packages and scripts written by researchers at the United States Geological Survey (USGS)
Idaho National Laboratory (INL) [Project Office](https://www.usgs.gov/centers/id-water/science/idaho-national-laboratory-project-office "USGS INL Project Office").

## Install

The current release is available on [CRAN](https://CRAN.R-project.org/package=inlmisc "The Comprehensive R Archive Network"),
which you can install using the following command:

```r
install.packages("inlmisc", dependencies = TRUE)
```

To install the development version, you need to clone the repository and build from source, or run:

```r
remotes::install_github("USGS-R/inlmisc", dependencies = TRUE)
```

## Contact

Please consider reporting bugs and asking questions on the [Issues page](https://github.com/USGS-R/inlmisc/issues).

## Disclaimer

This software has been approved for release by the U.S. Geological Survey
(USGS). Although the software has been subjected to rigorous review, the USGS
reserves the right to update the software as needed pursuant to further analysis
and review. No warranty, expressed or implied, is made by the USGS or the U.S.
Government as to the functionality of the software and related material nor
shall the fact of release constitute any such warranty. Furthermore, the
software is released on condition that neither the USGS nor the U.S. Government
shall be held liable for any damages resulting from its authorized or
unauthorized use.
