% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgnosticWrapper.R
\name{AgnosticWrapper}
\alias{AgnosticWrapper}
\title{Super class for model-agnostic interpretability methods}
\description{
This is a super class for all implemented model-agnostic
interpretability methods and inherits from the \code{\link{InterpretingMethod}}
class. Instead of just an object of the \code{\link{Converter}} class, any model
can now be passed. In contrast to the other model-specific methods in this
package, only the prediction function of the model is required, and not
the internal details of the model. The following model-agnostic methods
are available (all are wrapped by other packages):
\itemize{
\item \emph{Shapley values} (\code{\link{SHAP}}) based on \code{\link[fastshap:explain]{fastshap::explain}}
\item \emph{Local interpretable model-agnostic explanations}  (\code{\link{LIME}}) based on
\code{\link[lime:lime]{lime::lime}}
}
}
\section{Super class}{
\code{\link[innsight:InterpretingMethod]{innsight::InterpretingMethod}} -> \code{AgnosticWrapper}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data_orig}}{The individual instances to be explained by the method
(unprocessed!).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AgnosticWrapper-new}{\code{AgnosticWrapper$new()}}
\item \href{#method-AgnosticWrapper-clone}{\code{AgnosticWrapper$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="innsight" data-topic="InterpretingMethod" data-id="get_result"><a href='../../innsight/html/InterpretingMethod.html#method-InterpretingMethod-get_result'><code>innsight::InterpretingMethod$get_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="innsight" data-topic="InterpretingMethod" data-id="plot"><a href='../../innsight/html/InterpretingMethod.html#method-InterpretingMethod-plot'><code>innsight::InterpretingMethod$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="innsight" data-topic="InterpretingMethod" data-id="plot_global"><a href='../../innsight/html/InterpretingMethod.html#method-InterpretingMethod-plot_global'><code>innsight::InterpretingMethod$plot_global()</code></a></span></li>
<li><span class="pkg-link" data-pkg="innsight" data-topic="InterpretingMethod" data-id="print"><a href='../../innsight/html/InterpretingMethod.html#method-InterpretingMethod-print'><code>innsight::InterpretingMethod$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgnosticWrapper-new"></a>}}
\if{latex}{\out{\hypertarget{method-AgnosticWrapper-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of the \code{AgnosticWrapper} R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgnosticWrapper$new(
  model,
  data,
  data_ref,
  output_type = NULL,
  pred_fun = NULL,
  output_idx = NULL,
  output_label = NULL,
  channels_first = TRUE,
  input_dim = NULL,
  input_names = NULL,
  output_names = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{(any prediction model)\cr
A fitted model for a classification or regression task that
is intended to be interpreted. A \code{\link{Converter}} object can also be
passed. In order for the package to know how to make predictions
with the given model, a prediction function must also be passed with
the argument \code{pred_fun}. However, for models created by
\code{\link[torch]{nn_sequential}}, \code{\link[keras]{keras_model}},
\code{\link[neuralnet]{neuralnet}} or \code{\link{Converter}},
these have already been pre-implemented and do not need to be
specified.\cr}

\item{\code{data}}{(\code{array}, \code{data.frame} or \code{torch_tensor})\cr
The individual instances to be explained by the method.
These must have the same format as the input data of the passed model
and has to be either \code{\link{matrix}}, an \code{\link{array}}, a \code{\link{data.frame}} or a
\code{\link{torch_tensor}}. If no value is specified, all instances in the
dataset \code{data} will be explained.\cr
\strong{Note:} For the model-agnostic methods, only models with a single
input and output layer is allowed!\cr}

\item{\code{data_ref}}{(\code{\link{array}}, \code{\link{data.frame}} or \code{\link{torch_tensor}})\cr
The dataset to which the method is to be applied. These must
have the same format as the input data of the passed model and has to
be either \code{\link{matrix}}, an \code{\link{array}}, a \code{\link{data.frame}} or a
\code{\link{torch_tensor}}.\cr
\strong{Note:} For the model-agnostic methods, only models with a single
input and output layer is allowed!\cr}

\item{\code{output_type}}{(\code{character(1)})\cr
Type of the model output, i.e., either
\code{"classification"} or \code{"regression"}.\cr}

\item{\code{pred_fun}}{(\code{function})\cr
Prediction function for the model. This argument is only
needed if \code{model} is not a model created by
\code{\link[torch]{nn_sequential}}, \code{\link[keras]{keras_model}},
\code{\link[neuralnet]{neuralnet}} or \code{\link{Converter}}. The first argument of
\code{pred_fun} has to be \code{newdata}, e.g.,

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(newdata, ...) model(newdata)
}\if{html}{\out{</div>}}}

\item{\code{output_idx}}{(\code{integer}, \code{list} or \code{NULL})\cr
These indices specify the output nodes for which
the method is to be applied. In order to allow models with multiple
output layers, there are the following possibilities to select
the indices of the output nodes in the individual output layers:
\itemize{
\item An \code{integer} vector of indices: If the model has only one output
layer, the values correspond to the indices of the output nodes, e.g.,
\code{c(1,3,4)} for the first, third and fourth output node. If there are
multiple output layers, the indices of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{integer} vectors of indices: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired indices of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead of
a vector of indices, e.g., \code{list(NULL, c(1,3))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes in
the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more output
nodes.\cr
}}

\item{\code{output_label}}{(\code{character}, \code{factor}, \code{list} or \code{NULL})\cr
These values specify the output nodes for which
the method is to be applied. Only values that were previously passed with
the argument \code{output_names} in the \code{converter} can be used. In order to
allow models with multiple
output layers, there are the following possibilities to select
the names of the output nodes in the individual output layers:
\itemize{
\item A \code{character} vector or \code{factor} of labels: If the model has only one output
layer, the values correspond to the labels of the output nodes named in the
passed \code{Converter} object, e.g.,
\code{c("a", "c", "d")} for the first, third and fourth output node if the
output names are \code{c("a", "b", "c", "d")}. If there are
multiple output layers, the names of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{charactor}/\code{factor} vectors of labels: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired labels of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead of
a vector of labels, e.g., \code{list(NULL, c("a", "c"))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes in
the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more output
nodes.\cr
}}

\item{\code{channels_first}}{(\code{logical(1)})\cr
The channel position of the given data (argument
\code{data}). If \code{TRUE}, the channel axis is placed at the second position
between the batch size and the rest of the input axes, e.g.,
\code{c(10,3,32,32)} for a batch of ten images with three channels and a
height and width of 32 pixels. Otherwise (\code{FALSE}), the channel axis
is at the last position, i.e., \code{c(10,32,32,3)}. If the data
has no channel axis, use the default value \code{TRUE}.\cr}

\item{\code{input_dim}}{(\code{integer})\cr
The model input dimension excluding the batch
dimension. It can be specified as vector of integers, but has to be in
the format "channels first".\cr}

\item{\code{input_names}}{(\code{character}, \code{factor} or \code{list})\cr
The input names of the model excluding the batch dimension. For a model
with a single input layer and input axis (e.g., for tabular data), the
input names can be specified as a character vector or factor, e.g.,
for a dense layer with 3 input features use \code{c("X1", "X2", "X3")}. If
the model input consists of multiple axes (e.g., for signal and
image data), use a list of character vectors or factors for each axis
in the format "channels first", e.g., use
\code{list(c("C1", "C2"), c("L1","L2","L3","L4","L5"))} for a 1D
convolutional input layer with signal length 4 and 2 channels.\cr
\emph{Note:} This argument is optional and otherwise the names are
generated automatically. But if this argument is set, all found
input names in the passed model will be disregarded.\cr}

\item{\code{output_names}}{(\code{character}, \code{factor} )\cr
A character vector with the names for the output dimensions
excluding the batch dimension, e.g., for a model with 3 output nodes use
\code{c("Y1", "Y2", "Y3")}. Instead of a character
vector you can also use a factor to set an order for the plots.\cr
\emph{Note:} This argument is optional and otherwise the names are
generated automatically. But if this argument is set, all found
output names in the passed model will be disregarded.\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AgnosticWrapper-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AgnosticWrapper-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AgnosticWrapper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
