% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluations.R
\name{summary.ino}
\alias{summary.ino}
\title{Summary of initialization}
\usage{
\method{summary}{ino}(object, group = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{ino}.}

\item{group}{A character vector for grouping the optimization results, or \code{NULL}
(default) for no grouping.}

\item{...}{Named functions for computing statistics.}
}
\value{
A \code{data.frame}.
}
\description{
This function gives an overview of the initialization runs in an \code{ino}
object.
}
\details{
The following values are available for each \code{ino} object:
\itemize{
\item \code{.strategy}, the name of the initialization strategy,
\item \code{.optimizer}, the name of the optimizer (if more than one),
\item \code{.time}, the optimization time,
\item \code{.optimum}, the function value at the optimum.
}
}
\keyword{evaluation}
