% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_insee_idbank.R
\name{get_insee_idbank}
\alias{get_insee_idbank}
\title{Get data from INSEE series idbank}
\usage{
get_insee_idbank(
  ...,
  limit = TRUE,
  startPeriod = NULL,
  endPeriod = NULL,
  firstNObservations = NULL,
  lastNObservations = NULL,
  includeHistory = NULL,
  updatedAfter = NULL
)
}
\arguments{
\item{...}{one or several series key (idbank)}

\item{limit}{by default, the function get_insee_idbank has a 1200-idbank limit.
Set limit argument to FALSE to ignore the limit or modify the limit with the following command : Sys.setenv(INSEE_idbank_limit = 1200)}

\item{startPeriod}{start date of data}

\item{endPeriod}{end date of data}

\item{firstNObservations}{get the first N observations for each key series (idbank)}

\item{lastNObservations}{get the last N observations for each key series (idbank)}

\item{includeHistory}{boolean to access the previous releases (not available on all series)}

\item{updatedAfter}{starting point for querying the previous releases (format yyyy-mm-ddThh:mm:ss)}
}
\value{
a tibble with the data
}
\description{
Get data from INSEE series idbank
}
\details{
Get data from INSEE series idbanks.
The user can disable the download display in the console with the following command :
Sys.setenv(INSEE_download_verbose = "FALSE")
}
\examples{
\donttest{

#example 1 : import price index of industrial products and turnover index : manufacture of wood
data = get_insee_idbank("001558315", "010540726")

#example 2 : unemployment data

library(tidyverse)

idbank_list = get_idbank_list()

df_idbank_list_selected =
  idbank_list \%>\%
  filter(nomflow == "CHOMAGE-TRIM-NATIONAL") \%>\%  #unemployment dataset
  filter(dim5 == 0) \%>\% #men and women
  mutate(title = get_insee_title(idbank))

idbank_list_selected = df_idbank_list_selected \%>\% pull(idbank)

unem = get_insee_idbank(idbank_list_selected)

#example 3 : French GDP growth rate

library(tidyverse)

idbank_list = get_idbank_list()

df_idbank_list_selected =
  idbank_list \%>\%
  filter(nomflow == "CNT-2014-PIB-EQB-RF") \%>\%  # Gross domestic product balance
  filter(dim1 == "T") \%>\% #quarter
  filter(dim4 == "PIB") \%>\% #GDP
  filter(dim6 == "TAUX") \%>\% #rate
  filter(dim10 == "CVS-CJO") #SA-WDA, seasonally adjusted, working day adjusted

idbank = df_idbank_list_selected \%>\% pull(idbank)

data = get_insee_idbank(idbank)

#plot
ggplot(data, aes(x = DATE, y = OBS_VALUE)) +
geom_col() +
ggtitle("French GDP growth rate, quarter-on-quarter, sa-wda") +
labs(subtitle = sprintf("Last updated : \%s", data$TIME_PERIOD[1]))
}

}
