% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gera_distribution.R
\name{generalized_ratios_distribution}
\alias{generalized_ratios_distribution}
\alias{dgera}
\alias{rgera}
\title{The Generalized Ratio distribution}
\usage{
rgera(nsim, n1 = 1, n2 = 2, d)

dgera(x, n1 = 1, n2 = 2, d, log = FALSE)
}
\arguments{
\item{nsim}{integer, the number of observations to generate.}

\item{n1}{order of the first NN considered. Default is 1.}

\item{n2}{order of the second NN considered. Default is 2.}

\item{d}{value of the intrinsic dimension.}

\item{x}{vector of quantiles.}

\item{log}{logical, if \code{TRUE}, it returns the log-density}
}
\value{
\code{dgera} gives the density. \code{rgera} returns a vector of
random observations sampled from the generalized ratio distribution.
}
\description{
Density function and random number generator for the Generalized Ratio
distribution with NN orders equal to \code{n1} and \code{n2}.
See \href{https://arxiv.org/abs/2104.13832}{Denti et al., 2021+}
for more details.
}
\examples{
draws   <- rgera(100,3,5,2)
density <- dgera(3,3,5,2)

}
\references{
Denti F, Doimo D, Laio A, Mira A (2022+). "Distributional Results for
Model-Based Intrinsic Dimension Estimators."
arXiv preprint. 2104.13832, \url{https://arxiv.org/abs/2104.13832}.
}
