% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidalgo.R
\name{Hidalgo}
\alias{Hidalgo}
\alias{print.Hidalgo}
\alias{plot.Hidalgo}
\alias{summary.Hidalgo}
\alias{print.summary.Hidalgo}
\title{Fit the \code{Hidalgo} model}
\usage{
Hidalgo(
  X = NULL,
  dist_mat = NULL,
  K = 10,
  nsim = 5000,
  burn_in = 5000,
  thinning = 1,
  verbose = TRUE,
  q = 3,
  xi = 0.75,
  alpha_Dirichlet = 0.05,
  a0_d = 1,
  b0_d = 1,
  prior_type = c("Conjugate", "Truncated", "Truncated_PointMass"),
  D = NULL,
  pi_mass = 0.5
)

\method{print}{Hidalgo}(x, ...)

\method{plot}{Hidalgo}(x, type = c("A", "B", "C"), class = NULL, ...)

\method{summary}{Hidalgo}(object, ...)

\method{print}{summary.Hidalgo}(x, ...)
}
\arguments{
\item{X}{data matrix with \code{n} observations and \code{D} variables.}

\item{dist_mat}{distance matrix computed between the \code{n} observations.}

\item{K}{integer, number of mixture components.}

\item{nsim}{number of MCMC iterations to run.}

\item{burn_in}{number of MCMC iterations to discard as burn-in period.}

\item{thinning}{integer indicating the thinning interval.}

\item{verbose}{logical, should the progress of the sampler be printed?}

\item{q}{integer, first local homogeneity parameter. Default is 3.}

\item{xi}{real number between 0 and 1, second local homogeneity parameter.
Default is 0.75.}

\item{alpha_Dirichlet}{parameter of the symmetric Dirichlet prior
on the mixture weights. Default is 0.05, inducing a sparse mixture.
Values that are too small (i.e., lower than 0.005) may cause underflow.}

\item{a0_d}{shape parameter of the Gamma prior on \code{d}.}

\item{b0_d}{rate parameter of the Gamma prior on \code{d}.}

\item{prior_type}{character, type of Gamma prior on \code{d}, can be
\describe{
   \item{\code{"Conjugate"}}{a conjugate Gamma distribution is elicited;}
   \item{\code{"Truncated"}}{the conjugate Gamma prior is truncated over the
   interval \code{(0,D)};}
   \item{\code{"Truncated_PointMass"}}{same as \code{"Truncated"}, but a
   point mass is placed on \code{D}, to allow the \code{id} to be
   identically equal to the nominal dimension.}
}}

\item{D}{integer, the maximal dimension of the dataset.}

\item{pi_mass}{probability placed a priori on \code{D} when
\code{Truncated_PointMass} is chosen.}

\item{x}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo()} function.}

\item{...}{other arguments passed to specific methods.}

\item{type}{character that indicates the type of plot that is requested.
It can be:
\describe{
 \item{\code{"A"}}{plot the MCMC and the ergodic means NOT corrected
 for label switching;}
 \item{\code{"B"}}{plot the posterior mean and median of the id
 for each observation, after the chains are processed for label switching;}
 \item{\code{"C"}}{plot the estimated id distributions stratified by
 the groups specified in the class vector;}
 }}

\item{class}{factor variable used to stratify observations according to
their the \code{id} estimates.}

\item{object}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo()} function.}
}
\value{
object of class \code{Hidalgo}, which is a list containing
\describe{
    \item{\code{cluster_prob}}{chains of the posterior mixture weights;}
    \item{\code{membership_labels}}{chains of the membership labels for all
    the observations;}
    \item{\code{id_raw}}{chains of the \code{K} intrinsic dimensions
    parameters, one per mixture component;}
    \item{\code{id_postpr}}{a chain for each observation, corrected for
    label switching;}
    \item{\code{id_summary}}{a matrix containing, for each observation, the
    value of posterior mean and the 5\%, 25\%, 50\%, 75\%, 95\% quantiles;}
    \item{\code{recap}}{a list with the objects and specifications passed to
    the function used in the estimation.}
 }
}
\description{
The function fits the Heterogeneous intrinsic dimension algorithm, developed
in Allegra et al., 2020. The model is a Bayesian mixture of Pareto
distribution with modified likelihood to induce homogeneity across
neighboring observations. The model can segment the observations into
multiple clusters characterized by different
intrinsic dimensions. This permits to capture hidden patterns in the data.
For more details on the algorithm, refer to
\href{https://www.nature.com/articles/s41598-020-72222-0}{Allegra et al., 2020}.
For an example of application to basketball data, see
\href{https://imstat.org/journals-and-publications/annals-of-applied-statistics/annals-of-applied-statistics-next-issues/}{Santos-Fernandez et al., 2021}.
}
\examples{
\donttest{
X            <- replicate(5,rnorm(500))
X[1:250,1:2] <- 0
X[1:250,]    <- X[1:250,] + 4
oracle       <- rep(1:2,rep(250,2))
# this is just a short example
# increase the number of iterations to improve mixing and convergence
h_out        <- Hidalgo(X, nsim = 500, burn_in = 500)
plot(h_out, type =  "B")
id_by_class(h_out, oracle)
}


}
\references{
Allegra M, Facco E, Denti F, Laio A, Mira A (2020).
“Data segmentation based on the local intrinsic dimension.”
Scientific Reports, 10(1), 1–27. ISSN 20452322,
\doi{10.1038/s41598-020-72222-0, 1902.10459},

Santos-Fernandez E, Denti F, Mengersen K, Mira A (2021).
“The role of intrinsic dimension in high-resolution player tracking data –
Insights in basketball.” Annals of Applied Statistics - Forthcoming, –
ISSN 2331-8422, 2002.04148, \doi{10.1038/s41598-022-20991-1}
}
\seealso{
\code{\link{id_by_class}} and \code{\link{clustering}}
to understand how to further postprocess the results.
}
