% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_b.R
\name{naive_b}
\alias{naive_b}
\title{Initial values for the sieve maximum likelihood estimation}
\usage{
naive_b(data, v, u, c, q)
}
\arguments{
\item{data}{a data frame that includes the variables named in each argument}

\item{v}{the last observation time prior to the failure.}

\item{u}{the first observation time after the failure.}

\item{c}{an indicator of cause of failure. If an observation is righ-censored, \code{event = 0}; otherwise, \code{event = 1} or \code{event = 2}, where \code{1} represents the first cause of failure, and \code{2} represents the second cause of failure. The current version of package only allows for two causes of failure.}

\item{q}{a dimension of design matrix.}
}
\value{
Initial values of B-spline estimation
\item{b}{a vector of the initial values to be used in the optimization process}
}
\description{
The function \code{naive_b} provides a vector of initial values for the B-spline sieve maximum likelihood estimation.
}
\details{
The function \code{naive_b} provides initial values for the optimization procedure.
}
\examples{
attach(simdata)
intccr:::naive_b(data = simdata, v = v, u = u, c = c, q = 2)
}
\author{
Giorgos Bakoyannis, \email{gbakogia at iu dot edu}

Jun Park, \email{jp84 at iu dot edu}
}
\keyword{naive_b}
