% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicrosstab.r
\name{multicrosstab}
\alias{multicrosstab}
\title{Generate crosstabulation table(s)}
\usage{
multicrosstab(raster.layers, time.points, categories)
}
\arguments{
\item{raster.layers}{List of raster objects.}

\item{time.points}{a charachter vector showing the time point of each raster layer in chronological order.}

\item{categories}{A charachter vector showing the categories in the map. Order of categories decided bases on the equivalent IDs in the raster attribute table.}
}
\value{
The output is a list of crosstabulation table(s). The length of the list is equal to the number of intervals.
}
\description{
Generate crosstabulation table(s)
}
\details{
Read categorical raster objects, checks their dimentionality, resolution and extent are a perfect match. Then the function returns a list consist of a crosstabulation table for each consequtive pair of raster layers.
}
\examples{
raster_2005 <- raster::raster(system.file("external/RASTER_2005.RST", package="intensity.analysis"))
raster_2010 <- raster::raster(system.file("external/RASTER_2010.RST", package="intensity.analysis"))
raster_2012 <- raster::raster(system.file("external/RASTER_2012.RST", package="intensity.analysis"))
raster.layers <- list(raster_2005, raster_2010, raster_2012)
time.points <- c("2005","2010","2012")
categories <- c("Water","Trees","Impervious")
crosstabulation <- multicrosstab(raster.layers, time.points, categories)
}
