% Generated by roxygen2 (4.0.2): do not edit by hand
\name{variableImportance}
\alias{variableImportance}
\title{Permutation- based Variable Importance Measures}
\usage{
variableImportance(object = NULL, xdata = NULL, ydata = NULL, CV = 3,
  measure = "AUROC", sort = TRUE)
}
\arguments{
\item{object}{A model. Currently only binary classification models from the package \code{randomForest}.}

\item{xdata}{A data frame containing the predictors for the model.}

\item{ydata}{A factor containing the response variable.}

\item{CV}{Cross-validation. How many times should the data be permuted and the decrease in performance be calculated? Afterwards the mean is taken. CV should be higher for very small samples to ensure stability.}

\item{measure}{Currently only Area Under the Receiver Operating Characteristic Curve (AUROC) is supported.}

\item{sort}{Logical. Should the results be sorted from high to low?}
}
\value{
A data frame containing the variable names and the mean decrease in AUROC
}
\description{
\code{variableImportance} produces permutation- based variable importance measures (currently only for binary classification models from the package \code{randomForest} and only for the performance measure AUROC)
}
\details{
Currently only binary classification models from \code{randomForest} are supported. Also, currently only AUROC is supported. Definition of MeanDecreaseAUROC: for the entire ensemble the AUROC is recorded on the provided xdata. The same is subsequently done after permuting each variable (iteratively, for each variable separately). Then the latter is subtracted from the former. This is called the Decrease in AUROC. If we do this for multiple CV, it becomes the Mean Decrease in AUROC.
}
\examples{
#Prepare data
data(iris)
iris <- iris[1:100,]
iris$Species <- as.factor(ifelse(factor(iris$Species)=="setosa",0,1))
#Estimate model
library(randomForest)
ind <- sample(nrow(iris),50)
rf <- randomForest(Species~., iris[ind,])
#Obtain variable importances
variableImportance(object=rf, xdata=iris[-ind,names(iris) != "Species"],ydata=iris[-ind,]$Species)
}
\author{
Authors: Michel Ballings, and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\seealso{
\code{\link{parDepPlot}}
}

