% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_design.R
\name{fieldbook_design}
\alias{fieldbook_design}
\title{Field book experimental designs}
\usage{
fieldbook_design(
  data,
  n_factors = 1,
  type = "crd",
  rep = 2,
  serie = 2,
  seed = 0,
  qr = "FB"
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{n_factors}{Number of factor in the experiment(default = 1). See
details.}

\item{type}{Type of experimental arrange  (default = "crd"). See details.}

\item{rep}{Number of replications in the experiment (default = 3).}

\item{serie}{Digits in the plot id (default = 2).}

\item{seed}{Replicability of draw results (default = 0) always random. See
details.}

\item{qr}{Bar code prefix for data collection.}
}
\value{
A list with the fieldbook design
}
\description{
Function to deploy experimental designs based in agricolae package
}
\details{
The function allows to include the arguments in the sheet that have
  the information of the design. You should include 2 columns in the sheet:
  \code{{arguments}} and \code{{values}}. See examples. The information will
  be extracted automatically and deploy the design. \code{n_factors} = 1:
  crd, rcbd, lsd, lattice. \code{n_factors} = 2 (factorial): split_crd,
  split_rcbd \code{n_factors} >= 2 (factorial): crd, rcbd, lsd.
}
