% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2cal.R
\name{H2cal}
\alias{H2cal}
\title{Heritability in plant breeding}
\usage{
H2cal(
  data,
  trait,
  gen.name,
  rep.n,
  loc.n = 1,
  year.n = 1,
  loc.name = NULL,
  year.name = NULL,
  ran.model,
  fix.model,
  summary = FALSE,
  emmeans = FALSE,
  weights = NULL,
  plot_diag = FALSE,
  plot_dots = NULL,
  outliers.rm = FALSE
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and traits.}

\item{trait}{Name of the trait.}

\item{gen.name}{Name of the genotypes.}

\item{rep.n}{Number of replications in the experiment.}

\item{loc.n}{Number of locations (default = 1). See details.}

\item{year.n}{Number of years (default = 1). See details.}

\item{loc.name}{Name of the location (default = NULL). See details.}

\item{year.name}{Name of the years (default = NULL). See details.}

\item{ran.model}{The random effects in the model. See examples.}

\item{fix.model}{The fixed effects in the model. See examples.}

\item{summary}{Print summary from random model (default = FALSE).}

\item{emmeans}{Use emmeans for calculate the BLUEs (default = FALSE).}

\item{weights}{an optional vector of ‘prior weights’ to be used in the
fitting process (default = NULL).}

\item{plot_diag}{Show diagnostic plots (default = FALSE).}

\item{plot_dots}{Show dotplot genotypes vs trait (default = NULL). See
examples.}

\item{outliers.rm}{Remove outliers (default = FALSE). See references.}
}
\value{
list
}
\description{
Heritability in plant breeding on a genotype difference basis
}
\details{
The function allows to made the calculation for individual or
multi-environmental trials (MET) using th fixed and random model.

1. The variance components.

2. Heritability under three approaches: Standard, Cullis and Piepho.

3. Best Linear Unbiased Predictors (BLUPs).

4. Best Linear Unbiased Estimators (BLUEs).

5. Outliers remove.

For individual experiments is necessary provide the \code{trait},
\code{gen.name}, \code{rep.n}.

For MET experiments you should \code{loc.n} and \code{loc.name} and/or
\code{year.n} and \code{year.name} according your experiment.

The blues calculation is based in the pairwise comparison and its could takes
time according the number of the genotypes.

You can specify as \code{blues = FALSE} for calculate the variance components
and blups faster.

For more information review the references.
}
\examples{

library(inti)
library(agridat)

 dt <- john.alpha
 hr <- H2cal(data = dt
            , trait = "yield"
            , gen.name = "gen"
            , rep.n = 3
            , fix.model = "1 + rep + (1|rep:block) + gen"
            , ran.model = "1 + rep + (1|rep:block) + (1|gen)"
            , plot_diag = TRUE
            , emmeans = TRUE
            , outliers.rm = TRUE
            )
            
 hr$tabsmr
 hr$blues
 hr$blups
 
}
\references{
Schmidt, P., J. Hartung, J. Bennewitz, and H.P. Piepho. 2019. Heritability in
Plant Breeding on a Genotype Difference Basis. Genetics 212(4).

Schmidt, P., J. Hartung, J. Rath, and H.P. Piepho. 2019. Estimating Broad
Sense Heritability with Unbalanced Data from Agricultural Cultivar Trials.
Crop Science 59(2).

Bernal Vasquez, Angela Maria, et al. “Outlier Detection Methods for
Generalized Lattices: A Case Study on the Transition from ANOVA to REML.”
Theoretical and Applied Genetics, vol. 129, no. 4, Apr. 2016.
}
\author{
Maria Belen Kistner

Flavio Lozano Isla
}
