% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multi_Competing_optimization.R
\name{Multi_Competing_optimization}
\alias{Multi_Competing_optimization}
\title{Multi_Competing_optimization}
\usage{
Multi_Competing_optimization(X, y, n_variables, initial_products_cost)
}
\arguments{
\item{X}{a data frame of product prices at every event.}

\item{y}{integer vector with choices of a customer at each event , for example if the
competing products are only three , the possible choices are NA,1,2,3. NA being a consumer did not buy any thing at this event and he chose to walk away.}

\item{n_variables}{Number of products competing with each other.}

\item{initial_products_cost}{a vector of current costs for each product,for example if we have three products , it could be c(1.8,2.5,3.9).or
if there is no costs , it would be c(0,0,0)}
}
\value{
a data frame with the product names which are names of X,the intrinsic utility value,the current cost and the optimized price for each product
}
\description{
Calculating the optimum price based on consumer choice model for products that competes with each other.
}
\details{
for multiple products that are offered , some of these products compete with each other. for example; Beef, chicken and lamb. each of them provides
a certain value to consumer and are offered with different prices. this function calculates the intrinsic utility value -what is the perceived value of this product to the consumer- for competing products and optimize
thee price of each product accordingly. please note that the more the products you put in the model, the more processing time it will take due to complexity of optimization problem.it is recommended to
maximum of 8 products to your model.
}
\examples{
Multi_Competing_optimization(X= data.frame(Chedar_Cheese= runif(100,10,15),
Mozarella=runif(100,8,10),
Parmesan=runif(100,9,12)),y= as.numeric(rep(c(1,2,3,NA,2),20)),n_variables = 3,
initial_products_cost = c(8,6,7))
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
