% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian_funs.R
\name{hess_sd2}
\alias{hess_sd2}
\title{Inverse diagonal, method 2}
\usage{
hess_sd2(m)
}
\arguments{
\item{m}{A square numeric matrix, \eqn{n \times n}.}
}
\value{
A numeric vector of length \eqn{n}.
}
\description{
Get square root of diagonal of inverse matrix, second method
}
\details{
Following the procedure outlined in Gill & King
(2004): Calculate generalized inverse of a matrix `m` using [MASS::ginv()]. Then
perform a generalized Cholesky factorization of the generalized inverse using
[Matrix::Cholesky()] with `perm = TRUE`. Reconstruct the generalized inverse as

\deqn{\left(m^{-1} + E\right) = P_1^{\prime} L L^{\prime} P_1}

This should ensure positive semi-definiteness of the reconstruction.

Then, take the diagonal of \eqn{\left(m^{-1} + E \right)}, and take the square root.
}
\references{
Gill J, King G. (2004) What to Do When Your Hessian is Not
  Invertible: Alternatives to Model Respecification in Nonlinear Estimation.
  Sociological Methods & Research 33(1):54-87. DOI: 10.1177/0049124103262681
}
\author{
Caroline Ring
}
