% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_matrix_create.R
\name{coefficient_matrix_create}
\alias{coefficient_matrix_create}
\title{Create a coefficient matrix}
\usage{
coefficient_matrix_create(
  data_table,
  total = "output",
  digits = NULL,
  remove_empty = TRUE,
  households = FALSE,
  return_part = NULL
)
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, 
a margins or tax table retrieved by the  \code{\link{iotable_get}}
 function.}

\item{total}{Usually an output vector with a key column, defaults to 
\code{"output"} which equals \code{"P1"} or \code{"output_bp"}.
You can use other rows for comparison, for example \code{"TS_BP"} 
if it exists in the matrix.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}

\item{remove_empty}{Defaults to \code{TRUE}. If you want to keep empty 
primary input rows, choose \code{FALSE}. Empty product/industry rows are
always removed to avoid division by zero error in the analytic functions.}

\item{households}{Defaults to \code{NULL}. Household column can be added 
with \code{TRUE}.}

\item{return_part}{Defaults to \code{NULL}. You can choose \code{"product"} 
or \code{"industry"} to return an input coefficient matrix or
\code{"primary_inputs"} to get only the total intermediate use and 
proportional primary inputs.}
}
\value{
A data.frame that contains the matrix of  \code{data_table} divided 
by \code{total} with a key column. Optionally the results are rounded to 
given \code{digits}.
}
\description{
Create a coefficient matrix from a Symmetric Input-Output Table. The
coefficient matrix is related by default to output, but you can change
this to total supply or other total aggregate if it exists 
in your table.#'
}
\examples{
coefficient_matrix_create(data_table = iotable_get(source = "germany_1990"), 
                          total = "output", 
                          digits = 4 )
}
\references{
See 
\href{https://webarchive.nationalarchives.gov.uk/20160114044923/http://www.ons.gov.uk/ons/rel/input-output/input-output-analytical-tables/2010/index.html}{United Kingdom Input-Output Analytical Tables 2010}
for explanation on the use of the Coefficient matrix.
}
\seealso{
Other indicator functions: 
\code{\link{direct_effects_create}()},
\code{\link{input_indicator_create}()}
}
\concept{indicator functions}
