% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_interface.R
\name{ip_interface}
\alias{ip_interface}
\alias{ip_interface.default}
\alias{ip_interface.ip_address}
\alias{is_ip_interface}
\alias{as_ip_interface}
\alias{as_ip_interface.character}
\alias{as.character.ip_interface}
\alias{format.ip_interface}
\title{Vector of IP interfaces}
\usage{
ip_interface(...)

\method{ip_interface}{default}(x = character(), ...)

\method{ip_interface}{ip_address}(address, prefix_length, ...)

is_ip_interface(x)

as_ip_interface(x)

\method{as_ip_interface}{character}(x)

\method{as.character}{ip_interface}(x, ...)

\method{format}{ip_interface}(x, ...)
}
\arguments{
\item{...}{Included for S3 generic consistency}

\item{x}{\itemize{
\item For \code{ip_interface()}: A character vector of IP interfaces, in CIDR notation
(IPv4 or IPv6)
\item For \code{is_ip_interface()}: An object to test
\item For \code{as_ip_interface()}: An object to cast
\item For \code{as.character()}: An \code{ip_interface} vector
}}

\item{address}{An \code{\link{ip_address}} vector}

\item{prefix_length}{An integer vector}
}
\value{
An S3 vector of class \code{ip_interface}
}
\description{
This hybrid class stores both the host address and the network it is on.

\code{ip_interface()} constructs a vector of IP interfaces.

\code{is_ip_interface()} checks if an object is of class \code{ip_interface}.

\code{as_ip_interface()} casts an object to \code{ip_interface}.
}
\details{
Constructing an \code{ip_interface} vector is conceptually like constructing an
\code{\link{ip_network}} vector, except the host bits are retained.

The \code{ip_interface} class inherits from the \code{\link{ip_address}} class.
This means it can generally be used in places where an \code{\link{ip_address}}
vector is expected. A few exceptions to this rule are:
\itemize{
\item It does not support addition and subtraction of integers
\item It does not support bitwise operations
\item It cannot be compared to \code{\link{ip_address}} vectors
}

The \code{ip_interface} class additionally supports a few functions typically
reserved for \code{\link{ip_network}} vectors: \code{\link[=prefix_length]{prefix_length()}}, \code{\link[=netmask]{netmask()}} and
\code{\link[=hostmask]{hostmask()}}.

For other purposes, you can extract the address and network components using
\code{\link[=as_ip_address]{as_ip_address()}} and \code{\link[=as_ip_network]{as_ip_network()}}.
}
\examples{
# construct from character vector
ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))

# construct from address + prefix length objects
ip_interface(ip_address(c("192.168.0.1", "2001:db8:c3::abcd")), c(10L, 45L))

# extract IP address
x <- ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))
as_ip_address(x)

# extract IP network (with host bits masked)
as_ip_network(x)
}
\seealso{
\code{vignette("ipaddress-classes")}
}
