% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traverse_hierarchy.R
\name{traverse_hierarchy}
\alias{traverse_hierarchy}
\alias{supernet}
\alias{subnets}
\title{Traverse the network hierarchy}
\usage{
supernet(x, new_prefix = prefix_length(x) - 1L)

subnets(x, new_prefix = prefix_length(x) + 1L)
}
\arguments{
\item{x}{\itemize{
\item For \code{supernet()}: An \code{\link{ip_network}} vector
\item For \code{subnets()}: An \code{\link{ip_network}} scalar
}}

\item{new_prefix}{An integer vector indicating the desired prefix length.
By default, this steps a single level through the hierarchy.}
}
\value{
An \code{\link{ip_network}} vector
}
\description{
These functions step up and down the network hierarchy. \code{supernet()} returns
the supernetwork containing the given network. \code{subnets()} returns the list
of subnetworks which join to make the given network.
}
\details{
The \code{ipaddress} package does not support \link[base:LongVectors]{long vectors}
(i.e. vectors with more than 2^31 - 1 elements). The limits the number of
subnetworks that \code{subnets()} can return. However, you might find that machine
memory imposes stricter limitations.
}
\examples{
supernet(ip_network("192.168.0.0/24"))

supernet(ip_network("192.168.0.0/24"), new_prefix = 10L)

subnets(ip_network("192.168.0.0/24"))

subnets(ip_network("192.168.0.0/24"), new_prefix = 27L)
}
\seealso{
Use \code{\link[=seq.ip_network]{seq.ip_network()}} to list the addresses within a network.

Use \code{\link[=is_supernet]{is_supernet()}} and \code{\link[=is_subnet]{is_subnet()}} to check if one network is contained
within another.
}
