% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_question_text.R
\name{get_question_text}
\alias{get_question_text}
\title{get_question_text}
\usage{
get_question_text(question_code)
}
\arguments{
\item{question_code}{Code by which to identify the question.
Follows a dot-based naming scheme:
<group title>.<subquestion title>.}
}
\value{
`character` object containing the question text
}
\description{
Get the question text (e.g. "How have you been feeling?") to a
question in the dataset.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the ID 123456.
# In this survey, a multiple-choice question identified by the code "bdi.01"
# is used.
# For this question, this example retrieves the question text which was shown
# to the user when answering the questionnaire.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

q_text <- get_question_text("bdi.01")
}

}
