/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.toolkit.PlotColor;
import org.rosuda.ibase.toolkit.PlotManager;
import org.rosuda.ibase.toolkit.PlotObject;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;

public class PlotPolygon
extends PlotObject {
    double[] x;
    double[] y;
    int[] dx;
    int[] dy;
    boolean hasNaNs;
    Vector polys = new Vector();

    public PlotPolygon(PlotManager plotManager) {
        super(plotManager);
        this.setDrawColor(new PlotColor("black"));
    }

    public void set(double[] dArray, double[] dArray2) {
        if (Global.DEBUG > 0) {
            System.out.println("[" + this.toString() + "] set(x[],y[]): " + dArray + "/" + dArray2);
        }
        this.x = dArray;
        this.y = dArray2;
        this.recalc();
    }

    public void recalc() {
        int[] nArray;
        int[] nArray2;
        int n;
        int n2;
        if (this.x == null || this.y == null) {
            return;
        }
        int n3 = n2 = this.x.length > this.y.length ? this.y.length : this.x.length;
        if (this.dx == null || this.dy == null || this.dx.length != n2 || this.dy.length != n2) {
            this.dx = new int[n2];
            this.dy = new int[n2];
        }
        this.polys.removeAllElements();
        this.hasNaNs = false;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (Double.isNaN(this.x[n]) || Double.isNaN(this.y[n])) {
                if (n - n4 > 1) {
                    nArray2 = new int[n - n4];
                    nArray = new int[n - n4];
                    System.arraycopy(this.dx, n4, nArray2, 0, n - n4);
                    System.arraycopy(this.dy, n4, nArray, 0, n - n4);
                    this.polys.addElement(nArray2);
                    this.polys.addElement(nArray);
                    n4 = n + 1;
                }
                this.dx[n] = Integer.MIN_VALUE;
                this.dy[n] = Integer.MIN_VALUE;
                this.hasNaNs = true;
                continue;
            }
            this.dx[n] = this.getXPos(this.x[n]);
            this.dy[n] = this.getYPos(this.y[n]);
        }
        if (this.hasNaNs && n - n4 > 0) {
            nArray2 = new int[n - n4];
            nArray = new int[n - n4];
            System.arraycopy(this.dx, n4, nArray2, 0, n - n4);
            System.arraycopy(this.dy, n4, nArray, 0, n - n4);
            this.polys.addElement(nArray2);
            this.polys.addElement(nArray);
        }
    }

    public void draw(PoGraSS poGraSS) {
        int[] nArray;
        int[] nArray2;
        Enumeration enumeration;
        if (this.dx == null || this.dy == null || this.dx.length < 1) {
            return;
        }
        this.recalc();
        if (this.colf != null) {
            this.colf.use(poGraSS);
            if (this.hasNaNs) {
                enumeration = this.polys.elements();
                while (enumeration.hasMoreElements()) {
                    nArray2 = (int[])enumeration.nextElement();
                    nArray = (int[])enumeration.nextElement();
                    poGraSS.fillPolygon(nArray2, nArray, nArray2.length);
                }
            } else {
                poGraSS.fillPolygon(this.dx, this.dy, this.dx.length);
            }
        }
        if (this.cold != null) {
            this.cold.use(poGraSS);
            if (this.hasNaNs) {
                enumeration = this.polys.elements();
                while (enumeration.hasMoreElements()) {
                    nArray2 = (int[])enumeration.nextElement();
                    nArray = (int[])enumeration.nextElement();
                    poGraSS.drawPolyline(nArray2, nArray, nArray2.length);
                }
            } else {
                poGraSS.drawPolyline(this.dx, this.dy, this.dx.length);
            }
        }
    }

    public int[] getDX() {
        return this.dx;
    }

    public int[] getDY() {
        return this.dy;
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public String toString() {
        return "PlotPolygon(coord=" + this.coordX + ":" + this.coordY + ",dc=" + (this.cold == null ? "none" : this.cold.toString()) + ",fc=" + (this.colf == null ? "none" : this.colf.toString()) + ",points=" + (this.dx == null ? "none" : "" + this.dx.length) + ",visible=" + this.visible + ")";
    }
}

