% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.ipriorMod}
\title{Plots for \code{ipriorMod} objects}
\usage{
\method{plot}{ipriorMod}(x, plots = c("all", "allinone", "fitted",
  "diagnostic", "residuals", "qqplot"), own.labels = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{ipriorMod}.}

\item{plots}{Option to control which plots to show. The options are:
\describe{\item{\code{all}}{(default) All three plots are
shown.}\item{\code{allinone}}{All three plots are shown one one
screen.}\item{\code{fitted}}{Only the fitted regression curve is
shown.}\item{\code{diagnostic}}{The two diagnostic plots are
shown.}\item{\code{residuals}}{Only the plot of fitted against residuals
shown.}\item{\code{qqplot}}{Only the QQ-plot of the residuals is shown.}}}

\item{own.labels}{Logical, useful when categorical variables has factor names
which are long, because these are used as the points of the plots.}

\item{...}{No further arguments are passed, so this is not used here.}
}
\description{
Three plots are produced by default: Plot of fitted regression curve, plot of
fitted values against residuals, and a QQ-plot of the residuals. Note that
The plots of fitted regression line can be shown only if the explanatory
variable is of dimension one (i.e. only \code{p = 1} explanatory variable
used).
}
\examples{
# Straight line regression (Canonical RKHS)
mod.orange <- iprior(circumference ~ age, Orange)
plot(mod.orange)

# Multilevel model type plots (Canonical + Pearson RKHS)
mod.tooth1 <- iprior(len ~ ., ToothGrowth)
mod.tooth2 <- iprior(len ~ . ^ 2, ToothGrowth)
par(mfrow = c(1,2))
plot(mod.tooth1, plots = "fitted")  # random intercept
plot(mod.tooth2, plots = "fitted")  # random slopes & intercept

# One-dimensional smoothing (FBM RKHS with Hurst coef. 0.5)
mod.cars <- iprior(dist ~ speed, cars, model = list(kernel = "FBM"))
plot(mod.cars, plots = "fitted")

}
