% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{mutate}
\alias{mutate}
\alias{mutate.ir}
\alias{transmute.ir}
\title{Mutate an \code{ir} object by adding new or replacing existing columns}
\source{
\code{\link[dplyr:mutate]{dplyr::mutate()}}
}
\usage{
mutate.ir(
  .data,
  ...,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)

transmute.ir(.data, ...)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Name-value pairs.
The name gives the name of the column in the output.

The value can be:
\itemize{
\item A vector of length 1, which will be recycled to the correct length.
\item A vector the same length as the current group (or the whole data frame
if ungrouped).
\item \code{NULL}, to remove the column.
\item A data frame or tibble, to create multiple columns in the output.
}}

\item{.keep}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Control which columns from \code{.data} are retained in the output. Grouping
columns and columns created by \code{...} are always kept.
\itemize{
\item \code{"all"} retains all columns from \code{.data}. This is the default.
\item \code{"used"} retains only the columns used in \code{...} to create new
columns. This is useful for checking your work, as it displays inputs
and outputs side-by-side.
\item \code{"unused"} retains only the columns \emph{not} used in \code{...} to create new
columns. This is useful if you generate new columns, but no longer need
the columns used to generate them.
\item \code{"none"} doesn't retain any extra columns from \code{.data}. Only the grouping
variables and columns created by \code{...} are kept.
}}

\item{.before, .after}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, control where new columns
should appear (the default is to add to the right hand side). See
\code{\link[dplyr:relocate]{relocate()}} for more details.}
}
\value{
\code{.data} with modified columns. If the \code{spectra} column is dropped or
invalidated (see \code{\link[=ir_new_ir]{ir_new_ir()}}), the \code{ir} class is dropped, else the object
is of class \code{ir}.
}
\description{
Mutate an \code{ir} object by adding new or replacing existing columns
}
\examples{
## mutate
dplyr::mutate(ir_sample_data, hkl = klason_lignin + holocellulose)


## transmute
dplyr::transmute(ir_sample_data, hkl = klason_lignin + holocellulose)


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
