% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterAnalysis.R
\name{getConfigurationById}
\alias{getConfigurationById}
\title{Returns the configurations selected by ID.}
\usage{
getConfigurationById(iraceResults, ids, drop.metadata = FALSE)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}

\item{ids}{(\code{integer()})\cr The id or a vector of ids of the candidates configurations to obtain.}

\item{drop.metadata}{\code{logical(1)}\cr Remove metadata, such as the
configuration ID and the ID of the parent, from the returned
configurations.  See \code{\link[=removeConfigurationsMetaData]{removeConfigurationsMetaData()}}.}
}
\value{
A data frame containing the elite configurations required.
}
\description{
Returns the configurations selected by ID.
}
\examples{
log_file <- system.file("exdata/irace-acotsp.Rdata", package="irace", mustWork=TRUE)
getConfigurationById(log_file, ids = c(1,2), drop.metadata = TRUE)

}
\author{
Manuel López-Ibáñez and Leslie Pérez Cáceres
}
\concept{analysis}
