% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race-wrapper.R
\name{target_evaluator_default}
\alias{target_evaluator_default}
\title{target_evaluator_default}
\usage{
target_evaluator_default(
  experiment,
  num_configurations,
  all_conf_id,
  scenario,
  target_runner_call
)
}
\arguments{
\item{experiment}{A list describing the experiment. It contains at least:
\describe{
\item{\code{id_configuration}}{An alphanumeric string that uniquely identifies a configuration;}
\item{\code{id_instance}}{An alphanumeric string that uniquely identifies an instance;}
\item{\code{seed}}{Seed for the random number generator to be used for
this evaluation, ignore the seed for deterministic algorithms;}
\item{\code{instance}}{String giving the instance to be used for this evaluation;}
\item{\code{bound}}{(only when \code{capping} is enabled) Time bound for the execution;}
\item{\code{configuration}}{1-row data frame with a column per parameter
name;}
\item{\code{switches}}{Vector of parameter switches (labels) in the order
of parameters used in \code{configuration}.}
}}

\item{num_configurations}{Number of  configurations alive in the race.}

\item{all_conf_id}{Vector of configuration IDs of the alive configurations.}

\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}

\item{target_runner_call}{String describing the call to \code{targetRunner} that
corresponds to this call to \code{targetEvaluator}. This is used for
providing extra information to the user, for example, in case
\code{targetEvaluator} fails.}
}
\value{
The function \code{targetEvaluator} must return a list with one element
\code{"cost"}, the numerical value corresponding to the cost measure of the
given configuration on the given instance.

The return list may also contain the following optional elements that are used
by \pkg{irace} for reporting errors in \code{targetEvaluator}:
\describe{
\item{\code{error}}{is a string used to report an error;}
\item{\code{outputRaw}}{is a string used to report the raw output of calls to
an external program or function;}
\item{\code{call}}{is a string used to report how \code{targetRunner} called
an external program or function.}
}
}
\description{
\code{target_evaluator_default} is the default \code{targetEvaluator} function that is
invoked if \code{targetEvaluator} is a string (by default
\code{targetEvaluator} is \code{NULL} and this function is not invoked). You can use it as
an advanced example of how to create your own \code{targetEvaluator} function.
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
