% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_coord.R
\name{plot_configurations}
\alias{plot_configurations}
\title{Plot parameter configurations using parallel coordinates}
\usage{
plot_configurations(
  configurations,
  parameters,
  param_names = parameters$names,
  by_n_param = NULL,
  filename = NULL
)
}
\arguments{
\item{configurations}{Data frame, configurations in \code{irace} format
(example: \code{configurations = iraceResults$allConfigurations})}

\item{parameters}{(\code{list()}) Parameter space in irace format. See the function \code{\link[irace:readParameters]{irace::readParameters()}}.}

\item{param_names}{(\code{character()}) Parameters to be included in the plot. Example:
\code{c("algorithm","alpha","rho","q0","rasrank")}.}

\item{by_n_param}{Numeric (optional), maximum number of parameters to be displayed}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
parallel coordinates plot
}
\description{
Parallel coordinates plot of a set of provided configurations. Each line in
the plot represents a configuration.  The parameters to be included in the
plot can be selected with the param_names argument. Additionally, the
maximum number of parameters to be displayed in one plot. A list of plots is
returned by this function in several plots are required to display the
selected data.
}
\details{
To export the plot to a file, it is possible to do it so manually using the
functionality provided by plotly in the plot. If a filename is provided,
orca server will be used to export the plots and thus, it requires the library
to be installed (\url{https://github.com/plotly/orca}).
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
plot_configurations(iraceResults$allConfigurations[iraceResults$iterationElites,], 
                iraceResults$parameters)
plot_configurations(iraceResults$allConfigurations[iraceResults$iterationElites,], 
                iraceResults$parameters, 
                param_names = c("algorithm", "alpha", "rho", "q0", "rasrank"))
plot_configurations(iraceResults$allConfigurations[iraceResults$iterationElites,], 
                iraceResults$parameters, by_n_param = 5)
}
