% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_objects.R
\name{generate_ip}
\alias{generate_ip}
\title{Generate a random \code{Itempool} object}
\usage{
generate_ip(
  model = "3PL",
  n = NULL,
  output = "Itempool",
  n_categories = 4,
  se = NULL,
  ...
)
}
\arguments{
\item{model}{The model of the item pool}

\item{n}{The number of items in the item pool.}

\item{output}{The type of object returned. The default value is
\code{"Itempool"}.
\describe{
  \item{\strong{\code{"Itempool"}}}{Return an
    \code{\link{Itempool-class}} object.
    }
  \item{\strong{\code{"Item"}}}{If \code{n = 1} return an
    \code{\link{Item-class}} object. If \code{n > 1}, returns a list of
    \code{\link{Item-class}} object.
    }
  \item{\strong{\code{"list"}}}{Return a list of item
    \code{\link{Item-class}} objects.
    }
  }}

\item{n_categories}{For polytomous items, designate the number of categories
each item should have. It can be a single integer value larger than 1. In
this case all of the polytomous items will have this number of categories.
It can be a vector of length \code{n} designating the categories of each
item. For dichotomous items, the values in \code{n_categories} will be
ignored.}

\item{se}{The values of parameter standard errors for each item,
  i.e. a list
  object with elements named as parameter names (excluding \code{"D"}
  parameter).

  If the value is \code{TRUE}, this function will generate standard error
  values from a uniform distribution between 0.05 and 0.75 for each
  parameter of each item.}

\item{...}{Additional parameters passed to \code{itempool()} function.}
}
\value{
An \code{\link{Itempool-class}} object
}
\description{
Generate a random \code{Itempool} object
}
\examples{
# By default, a '3PL' model item pool generated
generate_ip()
# Designate the number of items
generate_ip(n = 12)
# Generate item pools for other models
generate_ip(model = "Rasch")
generate_ip(model = "1PL")
generate_ip(model = "2PL")
generate_ip(model = "4PL")
generate_ip(model = "GRM") # Graded Response Model
generate_ip(model = "GPCM") # Generalized Partial Credit Model
generate_ip(model = "PCM") # Partial Credit Model
generate_ip(model = "GPCM2") # Reparametrized GPCM
# Mixture of models
generate_ip(model = c("4PL", "Rasch"))
generate_ip(model = sample(c("4PL", "GPCM"), 12, TRUE))
generate_ip(model = c("2PL", "GRM", "Rasch"), n = 11)

# Generate parameters standard errors for each item
generate_ip(se_paramters = TRUE)

# Generate an item pool consist of testlets and standalone items
temp_list <- list(ids = paste0("testlet-", 1:7), n = c(2, 3, 4, 2, 3, 4, 2))
ip <- itempool(sample(c(
  generate_ip(n = 10, output = "list"),
  sapply(1:length(temp_list$ids), function(i)
    generate_testlet(testlet_id = temp_list$ids[i],
                     n = temp_list$item_models[i],
                     item_id_preamble = paste0("t", i, "-"))))))
}
\author{
Emre Gonulates
}
