% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icc.R
\name{plot_empirical_icc2}
\alias{plot_empirical_icc2}
\title{Plot Empirical Item Characteristic Curve}
\usage{
plot_empirical_icc2(
  resp,
  item,
  bins = 10,
  binwidth = NULL,
  ip = NULL,
  theta = NULL,
  title = "",
  suppress_plot = FALSE,
  x_axis_scale = NULL,
  n_dodge = 1,
  ...
)
}
\arguments{
\item{resp}{Response matrix.}

\item{item}{The column number, column name or the 'ID' of the  the item that
should be plotted.}

\item{bins}{An integer larger than 2 representing of ability groups examinees
should be grouped into. The default is \code{10}. The maximum value of
\code{bins +  1} is the number of possible total scores.}

\item{binwidth}{If 'theta' scale is used, the \code{binwidth} determines
the width of each bin of the theta scale. Within each bin, there might be
different number of examinees.}

\item{ip}{An \code{\link{Itempool-class}} object needs to be provided if
expected ICC desired.}

\item{theta}{A vector of examinee abilities.}

\item{title}{Title of the plot}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{x_axis_scale}{Set the scale of the x-axis. The default value is
\code{NULL}. For total score it will be defaulted to \code{"percent"}.
\describe{
  \item{\strong{\code{"percent"}}}{Percent interval.}
  \item{\strong{\code{"number"}}}{Numbers between 1 and \code{bins}}
  \item{\strong{\code{"theta"}}}{Theta values equally divided into bins.
  the middle value of the bin is shown in the x-axis. For example, if
  \code{bins = 10}, the first tick of the x-axis will be the mean of
  minimum theta value and tenth percentile theta value.}
  }}

\item{n_dodge}{The number of lines the x-axis tick labels should be written
to. This is especially useful if the x-axis tick labels overlap with each
other. The default value is \code{1}, which means all of the labels are
written on the same line.}

\item{...}{Extra parameters that will pass to \code{geom_line}.}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the empirical item or test characteristic curve or returns the plot object.
}
\description{
\code{plot_emprical_icc} plots empirical item characteristic curve.
 Examinees will be put into bins based on their total raw scores and the
 proportion of examinees who correctly answered an item for each bin will be
 plotted.
}
\examples{
ip <- generate_ip(model = c("3PL", "GRM"), n = 20)
true_theta <- rnorm(2000)
resp <- sim_resp(ip = ip, theta = true_theta)

# Provide item ID
plot_empirical_icc2(resp = resp, item = "Item_5")
# Provide item number
plot_empirical_icc2(resp, item = 3)
# Change x-axis scale
plot_empirical_icc2(resp, item = 3, x_axis_scale = "number")
# Change number of bins and x-axis scale
plot_empirical_icc2(resp, item = 3, bins = 11, x_axis_scale = "theta")
# Use bin width
plot_empirical_icc2(resp, item = 3, binwidth = 2)
# Use theta scores instead of raw scores
plot_empirical_icc2(resp, item = 3, binwidth = .2, ip = ip,
                    theta = true_theta)

# A GRM item
plot_empirical_icc2(resp, item = 4)
plot_empirical_icc2(resp, item = 4, x_axis_scale = "percent")
plot_empirical_icc2(resp, item = 4, x_axis_scale = "number")
plot_empirical_icc2(resp, item = 4, binwidth = 4)
# Use raw score and custom binwidth
plot_empirical_icc2(resp, item = 4, x_axis_scale = "percent", binwidth = 4)
# Use theta score
plot_empirical_icc2(resp, item = 4, binwidth = .2, ip = ip,
                    theta = true_theta)
# Add arguments for 'geom_line'
plot_empirical_icc2(resp, item = 4, binwidth = .2, ip = ip,
                    theta = true_theta, size = 1, alpha = .25)

}
\author{
Emre Gonulates
}
