% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_loglik.R
\name{resp_loglik}
\alias{resp_loglik}
\alias{resp_loglik,Item,ANY-method}
\alias{resp_loglik,Itempool,ANY-method}
\alias{resp_loglik,Testlet,ANY-method}
\alias{resp_loglik,numMatDfListChar,ANY-method}
\alias{resp_loglik,Itempool,Response-method}
\alias{resp_loglik,Itempool,Response_set-method}
\title{Log-likelihood of a Response String}
\usage{
resp_loglik(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{Item,ANY}(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{Itempool,ANY}(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{Testlet,ANY}(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{numMatDfListChar,ANY}(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{Itempool,Response}(ip, resp, theta, derivative = 0)

\S4method{resp_loglik}{Itempool,Response_set}(ip, resp, theta, derivative = 0)
}
\arguments{
\item{ip}{An \code{\link{Item-class}}, \code{\link{Itempool-class}} or a
\code{\link{Testlet-class}} object.}

\item{resp}{A vector of item responses.}

\item{theta}{An vector containing ability parameters.}

\item{derivative}{Whether to calculate the first or second derivative of
response log-likelihood.
\describe{
  \item{\code{0}}{No derivative will be calculated. This is the default
    value}
  \item{\code{1}}{Calculate the first derivative of the response
    log-likelihood}
  \item{\code{2}}{Calculate the second derivative of the response
    log-likelihood}
}}
}
\value{
A matrix of log-likelihood(s)
}
\description{
\code{resp_loglik} returns the log-likelihood of a response string
for given items and ability.
}
\examples{
item <- generate_item(model = "3PL")
theta <- rnorm(6)
resp <- sim_resp(ip = item, theta = theta, prop_missing = .1)
resp_loglik(ip = item, resp = resp, theta = theta)

item <- generate_item(model = "GRM")
resp <- sim_resp(ip = item, theta = theta, prop_missing = .1)
resp_loglik(ip = item, resp = resp, theta = theta)
ip <- generate_ip(model = "3PL")
theta <- rnorm(6)
resp <- sim_resp(ip = ip, theta = theta, prop_missing = .1)
resp_loglik(ip = ip, resp = resp, theta = theta)
resp_loglik(ip = ip, resp = resp, theta = theta, derivative = 1)
resp_loglik(ip = ip, resp = resp, theta = theta, derivative = 2)

ip <- generate_ip(model = "GPCM")
resp <- sim_resp(ip = ip, theta = theta, prop_missing = .1)
resp_loglik(ip = ip, resp = resp, theta = theta)
resp_loglik(ip = ip, resp = resp, theta = theta, derivative = 1)
resp_loglik(ip = ip, resp = resp, theta = theta, derivative = 2)
}
\author{
Emre Gonulates
}
