% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{score_info}
\alias{score_info}
\title{Calculate Score Information Function}
\usage{
score_info(true_theta, est_theta, bins = NULL)
}
\arguments{
\item{true_theta}{A vector of true theta values.}

\item{est_theta}{A vector of estimated theta values.}

\item{bins}{The number of bins true theta values should be grouped into.
Ideally, this value is \code{NULL} and equal number of simulees are
already in bins, and within each bin \code{true_theta} values are equal
to each other. If these conditions are not satisfied, a bin value can be
supplied.}
}
\value{
A data frame of true theta values and score information value at
  each theta value will be returned.
}
\description{
This function calculates the score information function of a
given CAT test. Ideally, a large number of simulees (say 1,000) will be
simulated at each theta level equally spaced along a large theta range (like
[-4, 4]). The score information function at each theta will be calculated
using the formulas 11-2 and 11-3 presented in Sands,  Waters and McBride
(1997, pages 127-128). Also see Lord (1980), Eqn. 10-7.

For example if 1000 examinees simulated at each of the following theta
values (-3, -2, -1, 0, 1, 2, 3), the function will not calculate score
information values at theta = -3 and theta = 3. Score information values
at second values to the edges (i.e. theta = -2 and theta = 2) will be
calculated using Equation 11-2 of Sands et.al (1997). The rest of the
score information values (at theta = -1, 0, 1) will be calculated using
equation 11-3 (page 128).
}
\examples{
ip <- generate_ip(n = 30)
cd <- create_cat_design(ip = ip, next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
# The following true_theta example is not ideal. For more informative score
# score information functions you can use more bins and more simulees like:
# rep(seq(-4, 4, .1), each = 1000)
true_theta <- rep(seq(-3, 3, 1), each = 10)
cat_data <- cat_sim(true_ability = true_theta, cd = cd)
dtf <- summary(cat_data)

s_info <- score_info(true_theta = dtf$true_ability,
                     est_theta = dtf$est_ability)
s_info

}
\references{
Lord, F. M. (1980). Applications of item response theory to practical
testing problems. Routledge.

Sands, W. A., Waters, B. K., & McBride, J. R. (1997). Computerized adaptive
testing: From inquiry to operation. American Psychological Association.
}
\author{
Emre Gonulates
}
