% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clumped.R
\name{temp_D48}
\alias{temp_D48}
\title{Dual clumped isotope thermometry}
\usage{
temp_D48(
  D47_CDES90,
  D48_CDES90,
  D47_error,
  D48_error,
  ks,
  add = FALSE,
  col = "black",
  pch = 19
)
}
\arguments{
\item{D47_CDES90}{Carbonate D47 values expressed on the CDES90 scale (‰).}

\item{D48_CDES90}{Carbonate D48 values expressed on the CDES90 scale (‰).}

\item{D47_error}{Error on the D47 value. Optional.}

\item{D48_error}{Error on the D48 value. Optional.}

\item{ks}{Kinetic slope. Has to be negative!}

\item{add}{Add graphics to an already existing plot? Default: \code{FALSE}.}

\item{col}{Graphical parameter. Optional.}

\item{pch}{Graphical parameter. Optional.}
}
\value{
Returns the carbonate growth temperature (°C). If both \code{D47_error} and
\code{D48_error} are specified \code{temp_D48()} returns a data frame.
}
\description{
\code{temp_D48()} calculates carbonate growth temperature from D47 and D48 values.
}
\details{
The function calculates a D47 value as an intersect of two curves:
the equilibrium D47 vs D48 curve from Fiebig et al. (2021) and
the kinetic slope. The resulting D47 value is then converted to temperature
using the \code{\link[=temp_D47]{temp_D47()}} function and the equilibrium
D47_CDES90 vs temperature equation of Fiebig et al. (2021).
}
\section{Contributors}{

The source code of this function contains elements
from the reconPlots package, available at
\url{https://github.com/andrewheiss/reconPlots}
}

\examples{
temp_D48(0.617, 0.139, ks = -0.6)
temp_D48(0.546, 0.277, ks = -1)

}
\references{
References are listed at \code{\link[=D48]{D48()}} and \code{\link[=D47]{D47()}}.
}
\seealso{
\code{\link[=D47]{D47()}} calculates the equilibrium carbonate D47 value.
\code{\link[=D48]{D48()}} calculates the equilibrium carbonate D48 value.

Other thermometry: 
\code{\link{temp_D47}()},
\code{\link{temp_d18O}()}
}
\concept{thermometry}
