% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{add_pulse_event}
\alias{add_pulse_event}
\title{Register a pulse event on one of the compartment of a topology}
\usage{
add_pulse_event(nm, time, comp = NULL, unmarked, marked, which = NULL, pulses)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{time}{Numeric, time at which the pulse is happening.}

\item{comp}{One compartment name only.}

\item{unmarked}{Numeric, quantity of unmarked marker added.}

\item{marked}{Numeric, quantity of marked marker added.}

\item{which}{Vector of integers giving the nm rows to update. Default is to
update all rows.}

\item{pulses}{Optionally, a tibble containing the pulse information in
columns. If provided, `comp`, `time`, `unmarked` and `marked` must be
strings giving the corresponding column names.}
}
\value{
A \code{networkModel} object.
}
\description{
When applied to a steady-state compartment, this is equivalent to changing
the steady state. Negative values are allowed, so one can add a "pulse" to a
steady-state compartment and then later add a similar but negative "pulse"
to simulate a drip in a stream for example.
}
\examples{
m <- trini_mod
m$events <- NULL
pulses <- tibble::tribble(
   ~ stream,    ~ transect, ~ comp, ~ time, ~ qty_14N, ~ qty_15N,
       "UL",  "transect.1",  "NH4",     11,         0,  -0.00569,
       "UL",  "transect.2",  "NH4",     11,         0,  -0.00264,
       "UL",  "transect.3",  "NH4",     11,         0, -0.000726,
       "UL",  "transect.1",  "NO3",     11,         0,  -0.00851,
       "UL",  "transect.2",  "NO3",     11,         0,  -0.01118,
       "UL",  "transect.3",  "NO3",     11,         0,  -0.01244,
   )
m <- add_pulse_event(m, pulses = pulses, comp = "comp", time = "time",
                     unmarked = "qty_14N", marked = "qty_15N")
m
 

}
