% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mating.R
\name{mating}
\alias{mating}
\alias{cross}
\alias{selfcross}
\alias{dh}
\title{Breed Simulated Individuals According to Basic Mating Schemes}
\usage{
cross(n = 1, p1, p2)

selfcross(n = 1, gid)

dh(n = 1, gid)
}
\arguments{
\item{n}{a length-one integer vector with the size of the progeny.}

\item{p1, p2, gid}{are instances of the class specimen which will be used 
as the parents.}
}
\value{
a size \emph{n} list with instances of the class Specimen that 
  represent new individuals belonging to the progeny of the respective mating 
  scheme.
}
\description{
Performs the simple mating schemes bi-parental cross, 
  self-cross and haploid duplication, respectively through the functions 
  \code{cross}, \code{selfcross} and \code{dh} and return the respective size 
  \emph{n} progeny involving the parental individuals belonging to the 
  same specie.
}
\details{
Basically this family of functions take simulated individuals 
  belonging to the same simulated specie, performs the meiosis that 
  generates individual's gametes. According to the scheme applied the 
  gametes are merged into new simulated individuals. These are wrap 
  functions to the C++ class that mimic the meiosis recombination process.
}
\examples{
data(ToyMap)
spc <- set_specie(ToyMap)
AA <- founder(spc, "AA")
aa <- founder(spc, "aa")

## Mather Design
F1  <- cross(n = 1, AA, aa)
BC1 <- cross(n = 5, F1, AA)
BC2 <- F1$cross(n = 5, aa)   # using R6 methods
F2  <- selfcross(n = 10, F1) 
RIL <- dh(n = 10, F1) 
## chainable R6 methods
F3  <- F1$selfcross(n = 1, replace = TRUE)$selfcross(n = 1, replace = TRUE)

}
