% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{set_specie}
\alias{set_specie}
\title{Constructor of Instances of the Specie Class}
\usage{
set_specie(data, meiosis = NULL)
}
\arguments{
\item{data}{A data frame with the map of the Genome to be simulates.}

\item{meiosis}{A pointer to a C++ function of the meiosis process.}
}
\value{
Objects of R6 class with methods to mimic in silico Genomes.
}
\description{
Constructor of instances of the Specie class given the map of
    the genome and optionally a pointer to a C++ function which will drive
    the meiosis process.
}
\details{
By standard the meiosis recombination and de novo genetic variability 
    is generated by means a count-location process 
    \insertCite{karlin1978}{isqg}. Users may define other process, see extdata
    for the examples presented in \insertCite{g3;textual}{isqg}.
}
\examples{
data(ToyMap)
spc_standard <- set_specie(ToyMap)

## generate standard _de novo_ variability
spc_standard$gamete(n = 100)

\dontrun{
## write your function in C++ and then wrap it as a pointer
## check the examples in extdata
## compile the code
Rcpp::sourceCpp(file = system.file("extdata", "Independent.cpp", package = "isqg"),
                rebuild = TRUE)

## define a specie w/ custom meiosis
spp_custom <- set_specie(ToyMap, meiosis = indepp())

## check meiosis process
spp_custom$gamete(n = 100)
}

}
\references{
\insertAllCited{}
}
