% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{plot_diff2}
\alias{plotDiff2D}
\alias{plot_diff2}
\title{Plot difference surface based on model predictions.}
\usage{
plot_diff2(model, view, comp, cond = NULL, color = "topo", nCol = 100,
  col = NULL, add.color.legend = TRUE, plotCI = FALSE, f = 1.96,
  n.grid = 30, nlevels = 10, zlim = NULL, xlim = NULL, ylim = NULL,
  main = NULL, xlab = NULL, ylab = NULL, rm.ranef = NULL,
  transform.view = NULL, hide.label = FALSE, dec = NULL,
  print.summary = getOption("itsadug_print"), ...)
}
\arguments{
\item{model}{A GAMM model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{view}{Name of continuous predictors that should be plotted on the x-
and y-axes. Vector of two values.}

\item{comp}{Named list with the grouping predictor (categorical variable)
and the 2 levels to calculate the difference for.}

\item{cond}{Named list of the values to use for the other predictor terms 
(not in view).}

\item{color}{Colorpalette}

\item{nCol}{Range of colors of background of contour plot.}

\item{col}{Line color.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{plotCI}{Logical: whether or not to plot confidence intervals.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting 
in 95\% confidence intervals. For 99\% confidence intervals use a value of 
2.58.}

\item{n.grid}{Resolution.}

\item{nlevels}{Levels of contour lines.}

\item{zlim}{A two item array giving the lower and upper limits for the z-
axis scale. NULL to choose automatically.}

\item{xlim}{A two item array giving the lower and upper limits for the x-
axis scale. NULL to choose automatically.}

\item{ylim}{A two item array giving the lower and upper limits for the y-
axis scale. NULL to choose automatically.}

\item{main}{Title of plot.}

\item{xlab}{Label x-axis.}

\item{ylab}{Label y-axis.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is FALSE. Alternatively a string (or vector of strings) with the 
name of the random effect(s) to remove.}

\item{transform.view}{List with two functions for transforming 
the values on the x- and y-axis respectively. If one of the axes 
need to be transformed, set the other to NULL (no transformation). 
(See \code{\link{fvisgam}} for more info.)}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., "difference"). Default is FALSE.}

\item{dec}{Numeric: number of decimals for rounding the color legend. 
When NULL (default), no rounding. If -1 (default), automatically determined. 
Note: if value = -1 (default), rounding will be applied also when 
\code{zlim} is provided.}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{...}{Optional arguments for \code{\link{plotsurface}}.}
}
\value{
If the result is not being plotted, a list is 
returned with the estimated difference (\code{est}) and the standard error 
over the estimate (\code{se.est}) and the x-values (\code{x}) is returned.
}
\description{
Plot difference surface based on model predictions.
}
\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
    data=simdat)
plot_diff2(m1, view=c('Time', 'Trial'), 
    comp=list(Group=c("Children", "Adults")))
}
}
\author{
Martijn Wieling, reimplemented by Jacolien van Rij
}
\seealso{
Other Testing for significance: \code{\link{compareML}},
  \code{\link{plot_diff}}, \code{\link{report_stats}},
  \code{\link{wald_gam}}
}

