% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{removeSplines}
\alias{removeSplines}
\title{Separating splines from MTR formulas}
\usage{
removeSplines(formula, env = parent.frame())
}
\arguments{
\item{formula}{the formula that is to be parsed.}

\item{env}{environment in which to formulas. This is necessary as
splines may be declared using objects, e.g. \code{knots = x},
where \code{x = c(0.3, 0.64, 0.9)}.}
}
\value{
a list containing two objects. One object is \code{formula}
    but with the spline components removed. The second object is a
    list. The name of each element is the
    \code{uSpline()}/\code{uSplines()} command, and the elements
    are a vector of the names of covariates that were interacted
    with the \code{uSpline()}/\code{uSplines()} command.
}
\description{
This function separates out the function calls \code{uSpline()} and
\code{uSplines()} potentially embedded in the MTR formulas from the
rest of the formula. The terms involving splines are treated
separately from the terms that do not involve splines when creating
the gamma moments.
}
\examples{
## Declare and MTR with a sline component.
m0 = ~ x1 + x1 : uSpline(degree = 2,
                          knots = c(0.2, 0.4)) +
            x2 : uSpline(degree = 2,
                          knots = c(0.2, 0.4)) +
            x1 : x2 : uSpline(degree = 2,
                               knots = c(0.2, 0.4)) +
            uSpline(degree = 3,
                     knots = c(0.2, 0.4),
                     intercept = FALSE)

## Now separate the spline component from the non-spline component
removeSplines(m0)

}
