% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivx.R
\name{ivx}
\alias{ivx}
\alias{print.ivx}
\title{Fitting IVX Models}
\usage{
ivx(
  formula,
  data,
  horizon,
  na.action,
  weights,
  contrasts = NULL,
  offset,
  model = TRUE,
  x = FALSE,
  y = FALSE,
  ...
)

\method{print}{ivx}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted.}

\item{data}{n optional data frame, list or environment (or object coercible by
\code{\link[base:as.data.frame]{as.data.frame}} to a data frame) containing
the variables in the model. If not found in data, the variables are taken
from environment(formula), typically the environment from which lm is called.}

\item{horizon}{is the horizon (default horizon = 1 corresponds to a
short-horizon regression).}

\item{na.action}{a function which indicates what should happen when the data
contain NAs. The default is set by the na.action setting of \code{\link[base:options]{options}},
and is \code{\link[stats:na.fail]{na.fail}} if that is unset. The ‘factory-fresh’
default is \code{\link[stats:na.fail]{na.omit}}. Another possible value is \code{NULL},
no action. Value \code{\link[stats:na.fail]{na.exclude}} can be useful.}

\item{weights}{an optional vector of weights to be used in the fitting process.
Should be \code{NULL} or a numeric vector. If non-NULL, weighted least squares is used
with weights \code{weights} (that is, minimizing \code{sum(w*e^2)}); otherwise ordinary
least squares is used.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of
\code{\link[stats:model.matrix]{model.matrix.default}}.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be NULL or a
numeric vector or matrix of extents matching those of the response. One or
more offset terms can be included in the formula instead or as well, and if more
than one are specified their sum is used. See \link[stats:model.extract]{model.offset}}

\item{model}{logical. If \code{TRUE} the model.frame of the fit is returned.}

\item{x}{an object of class "ivx", usually, a result of a call to ivx.}

\item{y}{logical. If \code{TRUE} the response of the fit is returned.}

\item{...}{additional arguments to be passed to the low level regression fitting
functions (see \link[stats:lm]{lm}).}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
an object of class "ivx".
}
\description{
ivx fits predictive regression models. The method allows standard
chi-square testing for regressors with different degrees of persistence,
from stationary to mildly explosive, and can be used for both short-
and long-horizon predictive regressions.
}
\examples{

# Univariate
ivx(Ret ~ LTY, data = kms)

# Multivariate
ivx(Ret ~ LTY + TBL, data = kms)

# Longer horizon
ivx(Ret ~ LTY + TBL, data = kms, horizon = 4)

wt <- runif(nrow(kms))
ivx(Ret ~ LTY, data = kms, weights = wt)

}
\references{
Magdalinos, T., & Phillips, P. (2009). Limit Theory for Cointegrated
Systems with Moderately Integrated and Moderately Explosive Regressors.
Econometric Theory, 25(2), 482-526.

Kostakis, A., Magdalinos, T., & Stamatogiannis, M. P. (2014).
Robust econometric inference for stock return predictability. The Review of
Financial Studies, 28(5), 1506-1553.
}
